/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.enscriber.blocks;

import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionManager;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.enscriber.EnscriberModule;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class EnscriberTileEntity
extends GenericTileEntity {
    public static final int SLOT_DIMLETS = 0;
    public static final int SIZE_DIMLETS = 91;
    public static final int SLOT_TAB = 91;
    private DescriptorError error = DescriptorError.OK;
    private int clientErrorCode = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(92).box(SlotDefinition.specific(DimletItem::isReadyDimlet), 0, 13, 7, 13, 7).slot(SlotDefinition.specific(EnscriberTileEntity::isDimensionTab), 91, 13, 142).playerSlots(85, 142));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid((slot, stack) -> {
        if (slot == 91) {
            return EnscriberTileEntity.isDimensionTab(stack);
        }
        return stack.func_77973_b() instanceof DimletItem;
    }).onUpdate((slot, stack) -> this.validateDimlets()).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Enscriber").containerSupplier(DefaultContainerProvider.container(EnscriberModule.CONTAINER_ENSCRIBER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).shortListener(Sync.integer(() -> this.error.getCode().ordinal(), v -> {
        this.clientErrorCode = v;
    })).setupSync((GenericTileEntity)this));
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    @ServerCommand
    public static final Command<?> CMD_STORE = Command.create((String)"enscriber.store", (te, player, params) -> te.storeDimlets(player, (String)params.get(PARAM_NAME)));
    @ServerCommand
    public static final Command<?> CMD_EXTRACT = Command.create((String)"enscriber.extract", (te, player, params) -> te.extractDimlets());

    public EnscriberTileEntity() {
        super((TileEntityType)EnscriberModule.TYPE_ENSCRIBER.get());
    }

    private static boolean isDimensionTab(ItemStack s) {
        return s.func_77973_b() == DimensionBuilderModule.EMPTY_DIMENSION_TAB.get() || s.func_77973_b() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get();
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(EnscriberTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/enscriber")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }
        };
    }

    public String getDimensionName() {
        CompoundNBT tagCompound;
        ItemStack stack = this.items.getStackInSlot(91);
        if (!stack.func_190926_b() && stack.func_77973_b() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get() && (tagCompound = stack.func_77978_p()) != null) {
            return tagCompound.func_74779_i("name");
        }
        return null;
    }

    private boolean checkOwnerDimlet() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            DimletKey dimletKey = DimletTools.getDimletKey(stack);
            if (!DimletTools.isOwnerDimlet(dimletKey)) continue;
            return true;
        }
        return false;
    }

    private void storeDimlets(PlayerEntity player, String name) {
        if (((Boolean)DimensionConfig.OWNER_DIMLET_REQUIRED.get()).booleanValue() && this.checkOwnerDimlet()) {
            Logging.warn((PlayerEntity)player, (String)"You need an owner dimlet to make a dimension!");
            return;
        }
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor(player);
        ItemStack realizedTab = this.createRealizedTab(descriptor);
        DimensionData data = PersistantDimensionManager.get(this.field_145850_b).getData(descriptor);
        if (data != null) {
            name = data.getId().func_110623_a();
            player.func_146105_b((ITextComponent)new StringTextComponent("This dimension already existed! If this is what you wanted then that's fine. Otherwise you need digit dimlets to make new unique dimensions. The dimlet sequence uniquely identifies a dimension. Names can't be changed").func_240699_a_(TextFormatting.YELLOW), false);
        } else if (!DimensionManager.get().isNameAvailable(this.field_145850_b, null, name)) {
            player.func_146105_b((ITextComponent)new StringTextComponent("This name is already used by another dimension!").func_240699_a_(TextFormatting.YELLOW), false);
            return;
        }
        for (int i = 0; i < 91; ++i) {
            this.items.setStackInSlot(i, ItemStack.field_190927_a);
        }
        realizedTab.func_196082_o().func_74778_a("name", name);
        this.items.setStackInSlot(91, realizedTab);
        this.func_70296_d();
    }

    private ItemStack createRealizedTab(DimensionDescriptor descriptor) {
        ItemStack realizedTab = new ItemStack((IItemProvider)DimensionBuilderModule.REALIZED_DIMENSION_TAB.get(), 1);
        CompoundNBT tagCompound = realizedTab.func_196082_o();
        String compact = descriptor.compact();
        tagCompound.func_74778_a("descriptor", compact);
        PersistantDimensionManager mgr = PersistantDimensionManager.get(this.field_145850_b);
        DimensionData data = mgr.getData(descriptor);
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        if (data != null) {
            tagCompound.func_74768_a("ticksLeft", 0);
            tagCompound.func_74778_a("dimension", data.getId().toString());
            compiledDescriptor.compile(descriptor, data.getRandomizedDescriptor());
        } else {
            compiledDescriptor.compile(descriptor, DimensionDescriptor.EMPTY);
            tagCompound.func_74768_a("ticksLeft", compiledDescriptor.getActualTickCost());
        }
        tagCompound.func_74768_a("tickCost", compiledDescriptor.getActualTickCost());
        tagCompound.func_74768_a("rfCreateCost", compiledDescriptor.getCreateCostPerTick());
        tagCompound.func_74768_a("rfMaintainCost", compiledDescriptor.getActualPowerCost());
        return realizedTab;
    }

    private DimensionDescriptor convertToDimensionDescriptor(@Nullable PlayerEntity player) {
        DimensionDescriptor descriptor = new DimensionDescriptor();
        List<DimletKey> dimlets = descriptor.getDimlets();
        long forcedSeed = 0L;
        for (int i = 0; i < 91; ++i) {
            ItemStack stack = this.items.getStackInSlot(i + 0);
            if (stack.func_190926_b()) continue;
            DimletKey key = DimletTools.getDimletKey(stack);
            DimletSettings settings = DimletDictionary.get().getSettings(key);
            if (settings != null) {
                dimlets.add(key);
                CompoundNBT tagCompound = stack.func_77978_p();
                if (tagCompound == null || tagCompound.func_74763_f("forcedSeed") == 0L) continue;
                forcedSeed = tagCompound.func_74763_f("forcedSeed");
                continue;
            }
            if (player == null) continue;
            Logging.warn((PlayerEntity)player, (String)("Dimlet " + key.getType().name() + "." + key.getKey() + " was not included in the tab because it is blacklisted"));
        }
        return descriptor;
    }

    private void validateDimlets() {
        DimensionDescriptor descriptor = this.convertToDimensionDescriptor(null);
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        this.error = compiledDescriptor.compile(descriptor, DimensionDescriptor.EMPTY);
    }

    public int getClientErrorCode() {
        return this.clientErrorCode;
    }

    private void extractDimlets() {
        ItemStack realizedTab = this.items.getStackInSlot(91);
        CompoundNBT tagCompound = realizedTab.func_77978_p();
        if (tagCompound != null) {
            long forcedSeed = tagCompound.func_74763_f("forcedSeed");
            String descString = tagCompound.func_74779_i("descriptor");
            DimensionDescriptor descriptor = new DimensionDescriptor();
            descriptor.read(descString);
            List<DimletKey> dimlets = descriptor.getDimlets();
            int idx = 0;
            for (DimletKey key : dimlets) {
                boolean hasDimension = tagCompound.func_74764_b("dimension");
                if (((Boolean)DimensionConfig.OWNER_DIMLET_REQUIRED.get()).booleanValue() && hasDimension && DimletTools.isOwnerDimlet(key)) continue;
                ItemStack dimletStack = DimletTools.getDimletStack(key);
                this.items.setStackInSlot(idx, dimletStack);
                ++idx;
            }
        }
        this.items.setStackInSlot(91, new ItemStack((IItemProvider)DimensionBuilderModule.EMPTY_DIMENSION_TAB.get()));
        this.func_70296_d();
    }
}

