/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.recipes.DimletRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class DimletRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<DimletRecipe> {
    private final ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();

    @Nonnull
    public DimletRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ShapedRecipe recipe = this.serializer.func_199425_a_(recipeId, json);
        String typeString = json.getAsJsonPrimitive("dimlettype").getAsString();
        DimletType type = DimletType.byName(typeString);
        String key = json.getAsJsonPrimitive("dimletkey").getAsString();
        return new DimletRecipe(recipe, new DimletKey(type, key));
    }

    public DimletRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull PacketBuffer buffer) {
        ShapedRecipe recipe = this.serializer.func_199426_a_(recipeId, buffer);
        String typeString = buffer.func_150789_c(Short.MAX_VALUE);
        DimletType type = DimletType.byName(typeString);
        String key = buffer.func_150789_c(Short.MAX_VALUE);
        return new DimletRecipe(recipe, new DimletKey(type, key));
    }

    public void toNetwork(@Nonnull PacketBuffer buffer, DimletRecipe recipe) {
        this.serializer.func_199427_a_(buffer, recipe.getRecipe());
        buffer.func_180714_a(recipe.getKey().getType().name());
        buffer.func_180714_a(recipe.getKey().getKey());
    }
}

