/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.lootmodifier;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootPoolEntryType;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.JSONUtils;

public class DimletLootEntry
extends StandaloneLootEntry {
    private final DimletRarity rarity;
    private final Random random = new Random();

    public DimletLootEntry(int weightIn, int qualityIn, ILootCondition[] conditionsIn, ILootFunction[] functionsIn, DimletRarity rarity) {
        super(weightIn, qualityIn, conditionsIn, functionsIn);
        this.rarity = rarity;
    }

    protected void func_216154_a(@Nonnull Consumer<ItemStack> stackConsumer, @Nonnull LootContext context) {
        DimletKey dimlet = DimletDictionary.get().getRandomDimlet(this.rarity, this.random);
        if (dimlet != null) {
            stackConsumer.accept(DimletTools.getDimletStack(dimlet));
        }
    }

    public DimletRarity getRarity() {
        return this.rarity;
    }

    @Nonnull
    public LootPoolEntryType func_230420_a_() {
        return DimletModule.DIMLET_LOOT_ENTRY;
    }

    public static StandaloneLootEntry.Builder<?> builder(DimletRarity rarity) {
        return DimletLootEntry.func_216156_a((weight, quality, conditions, functions) -> new DimletLootEntry(weight, quality, conditions, functions, rarity));
    }

    public static class Serializer
    extends StandaloneLootEntry.Serializer<DimletLootEntry> {
        public void serializeCustom(@Nonnull JsonObject object, @Nonnull DimletLootEntry entry, @Nonnull JsonSerializationContext conditions) {
            super.func_230422_a_(object, (StandaloneLootEntry)entry, conditions);
            object.addProperty("rarity", entry.getRarity().name());
        }

        @Nonnull
        protected DimletLootEntry deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext context, int weight, int quality, @Nonnull ILootCondition[] conditions, @Nonnull ILootFunction[] functions) {
            String rarityString = JSONUtils.func_151200_h((JsonObject)object, (String)"rarity");
            DimletRarity rarity = DimletRarity.byName(rarityString);
            return new DimletLootEntry(weight, quality, conditions, functions, rarity);
        }
    }
}

