/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import java.util.HashMap;
import java.util.Map;

public enum DimletType {
    TERRAIN("t"),
    ATTRIBUTE("a"),
    BIOME_CONTROLLER("bc"),
    BIOME("bi"),
    FEATURE("f"),
    TIME("ti"),
    BLOCK("b"),
    DIGIT("d"),
    ADMIN("ad"),
    FLUID("fl");

    private final String shortName;
    private static final Map<String, DimletType> TYPE_MAP;

    private DimletType(String shortName) {
        this.shortName = shortName;
    }

    public boolean usesKnowledgeSystem() {
        return this != DIGIT && this != ADMIN;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static DimletType byName(String name) {
        return TYPE_MAP.get(name.toLowerCase());
    }

    static {
        TYPE_MAP = new HashMap<String, DimletType>();
        for (DimletType type : DimletType.values()) {
            TYPE_MAP.put(type.getShortName().toLowerCase(), type);
            TYPE_MAP.put(type.name().toLowerCase(), type);
        }
    }
}

