/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.data;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsdim.dimension.AdminDimletType;
import mcjty.rftoolsdim.modules.dimlets.DimletModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletRarity;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import mcjty.rftoolsdim.modules.dimlets.items.DimletItem;
import mcjty.rftoolsdim.modules.essences.EssencesModule;
import mcjty.rftoolsdim.modules.essences.blocks.BiomeAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.BlockAbsorberTileEntity;
import mcjty.rftoolsdim.modules.essences.blocks.FluidAbsorberTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class DimletTools {
    public static String getDimletDescription(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        return DimletTools.getReadableName(key);
    }

    public static String getDimletRarity(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null) {
            DimletRarity rarity = settings.getRarity();
            return rarity.name();
        }
        return "<Unknown>";
    }

    public static String getDimletCost(ItemStack stack) {
        DimletKey key = DimletTools.getDimletKey(stack);
        if (key == null) {
            return "<Unknown>";
        }
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings != null) {
            int createCost = settings.getCreateCost();
            int maintainCost = settings.getMaintainCost();
            int tickCost = settings.getTickCost();
            return "C " + createCost + ", M " + maintainCost + ", T " + tickCost;
        }
        return "<Unknown>";
    }

    private static DimletItem getDimletItem(DimletType type) {
        switch (type) {
            case TERRAIN: {
                return (DimletItem)DimletModule.TERRAIN_DIMLET.get();
            }
            case ATTRIBUTE: {
                return (DimletItem)DimletModule.ATTRIBUTE_DIMLET.get();
            }
            case BIOME_CONTROLLER: {
                return (DimletItem)DimletModule.BIOME_CONTROLLER_DIMLET.get();
            }
            case BIOME: {
                return (DimletItem)DimletModule.BIOME_DIMLET.get();
            }
            case FEATURE: {
                return (DimletItem)DimletModule.FEATURE_DIMLET.get();
            }
            case TIME: {
                return (DimletItem)DimletModule.TIME_DIMLET.get();
            }
            case BLOCK: {
                return (DimletItem)DimletModule.BLOCK_DIMLET.get();
            }
            case FLUID: {
                return (DimletItem)DimletModule.FLUID_DIMLET.get();
            }
            case DIGIT: {
                return (DimletItem)DimletModule.DIGIT_DIMLET.get();
            }
            case ADMIN: {
                return (DimletItem)DimletModule.ADMIN_DIMLET.get();
            }
        }
        return null;
    }

    private static DimletItem getEmptyDimletItem(DimletType type) {
        switch (type) {
            case TERRAIN: {
                return (DimletItem)DimletModule.EMPTY_TERRAIN_DIMLET.get();
            }
            case ATTRIBUTE: {
                return (DimletItem)DimletModule.EMPTY_ATTRIBUTE_DIMLET.get();
            }
            case BIOME_CONTROLLER: {
                return (DimletItem)DimletModule.EMPTY_BIOME_CONTROLLER_DIMLET.get();
            }
            case BIOME: {
                return (DimletItem)DimletModule.EMPTY_BIOME_DIMLET.get();
            }
            case FEATURE: {
                return (DimletItem)DimletModule.EMPTY_FEATURE_DIMLET.get();
            }
            case TIME: {
                return (DimletItem)DimletModule.EMPTY_TIME_DIMLET.get();
            }
            case BLOCK: {
                return (DimletItem)DimletModule.EMPTY_BLOCK_DIMLET.get();
            }
            case FLUID: {
                return (DimletItem)DimletModule.EMPTY_FLUID_DIMLET.get();
            }
            case DIGIT: {
                return null;
            }
            case ADMIN: {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static DimletKey getDimletKey(ItemStack stack) {
        CompoundNBT tag;
        DimletType type;
        if (stack.func_77973_b() instanceof DimletItem && (type = ((DimletItem)stack.func_77973_b()).getType()) != null && (tag = stack.func_77978_p()) != null) {
            String name = tag.func_74779_i("name");
            return new DimletKey(type, name);
        }
        return null;
    }

    @Nonnull
    public static ItemStack getDimletStack(DimletKey key) {
        DimletItem item = DimletTools.getDimletItem(key.getType());
        ItemStack stack = new ItemStack((IItemProvider)item);
        stack.func_196082_o().func_74778_a("name", key.getKey());
        return stack;
    }

    @Nonnull
    public static ItemStack getEmptyDimletStack(DimletType type) {
        DimletItem item = DimletTools.getEmptyDimletItem(type);
        return new ItemStack((IItemProvider)item);
    }

    public static ItemStack getNeededMemoryPart(DimletKey key) {
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return ItemStack.field_190927_a;
        }
        DimletRarity rarity = settings.getRarity();
        if (rarity == null) {
            return ItemStack.field_190927_a;
        }
        switch (rarity) {
            case COMMON: {
                return new ItemStack((IItemProvider)DimletModule.PART_MEMORY_0.get());
            }
            case UNCOMMON: {
                return new ItemStack((IItemProvider)DimletModule.PART_MEMORY_1.get());
            }
            case RARE: {
                return new ItemStack((IItemProvider)DimletModule.PART_MEMORY_2.get());
            }
            case LEGENDARY: {
                return new ItemStack((IItemProvider)DimletModule.PART_MEMORY_3.get());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getNeededEnergyPart(DimletKey key) {
        DimletSettings settings = DimletDictionary.get().getSettings(key);
        if (settings == null) {
            return ItemStack.field_190927_a;
        }
        DimletRarity rarity = settings.getRarity();
        if (rarity == null) {
            return ItemStack.field_190927_a;
        }
        switch (rarity) {
            case COMMON: {
                return new ItemStack((IItemProvider)DimletModule.PART_ENERGY_0.get());
            }
            case UNCOMMON: {
                return new ItemStack((IItemProvider)DimletModule.PART_ENERGY_1.get());
            }
            case RARE: {
                return new ItemStack((IItemProvider)DimletModule.PART_ENERGY_2.get());
            }
            case LEGENDARY: {
                return new ItemStack((IItemProvider)DimletModule.PART_ENERGY_3.get());
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getNeededEssence(DimletKey key, @Nonnull DimletSettings settings) {
        if (!settings.getEssence().func_190926_b()) {
            return settings.getEssence();
        }
        switch (key.getType()) {
            case TERRAIN: {
                return ItemStack.field_190927_a;
            }
            case ATTRIBUTE: {
                return ItemStack.field_190927_a;
            }
            case BIOME_CONTROLLER: {
                return ItemStack.field_190927_a;
            }
            case BIOME: {
                return new ItemStack((IItemProvider)EssencesModule.BIOME_ABSORBER_ITEM.get());
            }
            case FEATURE: {
                return ItemStack.field_190927_a;
            }
            case TIME: {
                return ItemStack.field_190927_a;
            }
            case BLOCK: {
                return new ItemStack((IItemProvider)EssencesModule.BLOCK_ABSORBER_ITEM.get());
            }
            case FLUID: {
                return new ItemStack((IItemProvider)EssencesModule.FLUID_ABSORBER_ITEM.get());
            }
            case DIGIT: {
                return ItemStack.field_190927_a;
            }
            case ADMIN: {
                return ItemStack.field_190927_a;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public static ResourceLocation getResourceLocation(DimletKey dimletKey) {
        switch (dimletKey.getType()) {
            case TERRAIN: {
                return null;
            }
            case ATTRIBUTE: {
                return null;
            }
            case BIOME_CONTROLLER: {
                return null;
            }
            case BIOME: {
                return new ResourceLocation(dimletKey.getKey());
            }
            case FEATURE: {
                return null;
            }
            case TIME: {
                return null;
            }
            case BLOCK: {
                return new ResourceLocation(dimletKey.getKey());
            }
            case FLUID: {
                return new ResourceLocation(dimletKey.getKey());
            }
            case DIGIT: {
                return null;
            }
            case ADMIN: {
                return null;
            }
        }
        return null;
    }

    public static ITextComponent getReadable(DimletKey dimletKey) {
        switch (dimletKey.getType()) {
            case TERRAIN: {
                return new StringTextComponent(dimletKey.getKey().toLowerCase());
            }
            case ATTRIBUTE: {
                return new StringTextComponent(dimletKey.getKey().toLowerCase());
            }
            case BIOME_CONTROLLER: {
                return new StringTextComponent(dimletKey.getKey().toLowerCase());
            }
            case BIOME: {
                ResourceLocation id = new ResourceLocation(dimletKey.getKey());
                String trans = "biome." + id.func_110624_b() + "." + id.func_110623_a();
                return new TranslationTextComponent(trans);
            }
            case FEATURE: {
                return new StringTextComponent(dimletKey.getKey().toLowerCase());
            }
            case TIME: {
                return new StringTextComponent(dimletKey.getKey().toLowerCase());
            }
            case BLOCK: {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(dimletKey.getKey()));
                return new TranslationTextComponent(block.func_149739_a());
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(dimletKey.getKey()));
                return new TranslationTextComponent(fluid.func_207188_f().func_206883_i().func_177230_c().func_149739_a());
            }
            case DIGIT: {
                return new StringTextComponent(dimletKey.getKey());
            }
            case ADMIN: {
                return new StringTextComponent(dimletKey.getKey());
            }
        }
        return new StringTextComponent("<unknown>");
    }

    public static String getReadableName(DimletKey dimletKey) {
        switch (dimletKey.getType()) {
            case TERRAIN: {
                return dimletKey.getKey().toLowerCase();
            }
            case ATTRIBUTE: {
                return dimletKey.getKey().toLowerCase();
            }
            case BIOME_CONTROLLER: {
                return dimletKey.getKey().toLowerCase();
            }
            case BIOME: {
                ResourceLocation id = new ResourceLocation(dimletKey.getKey());
                String trans = "biome." + id.func_110624_b() + "." + id.func_110623_a();
                return I18n.func_135052_a((String)trans, (Object[])new Object[0]);
            }
            case FEATURE: {
                return dimletKey.getKey().toLowerCase();
            }
            case TIME: {
                return dimletKey.getKey().toLowerCase();
            }
            case BLOCK: {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(dimletKey.getKey()));
                if (block != null) {
                    String modName = Tools.getModName((IForgeRegistryEntry)block);
                    if ("minecraft".equalsIgnoreCase(modName)) {
                        return I18n.func_135052_a((String)block.func_149739_a(), (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)block.func_149739_a(), (Object[])new Object[0]) + " (" + modName + ")";
                }
                return "<Invalid " + dimletKey.getKey() + ">";
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(dimletKey.getKey()));
                if (fluid != null) {
                    String modName = Tools.getModName((IForgeRegistryEntry)fluid);
                    if ("minecraft".equalsIgnoreCase(modName)) {
                        return I18n.func_135052_a((String)fluid.func_207188_f().func_206883_i().func_177230_c().func_149739_a(), (Object[])new Object[0]);
                    }
                    return I18n.func_135052_a((String)fluid.func_207188_f().func_206883_i().func_177230_c().func_149739_a(), (Object[])new Object[0]) + " (" + modName + ")";
                }
                return "<Invalid " + dimletKey.getKey() + ">";
            }
            case DIGIT: {
                return dimletKey.getKey();
            }
            case ADMIN: {
                return dimletKey.getKey();
            }
        }
        return "<unknown>";
    }

    public static boolean isFullEssence(ItemStack stack, ItemStack desired, String desiredKey) {
        if (stack.func_77969_a(desired)) {
            if (stack.func_77973_b() == EssencesModule.BIOME_ABSORBER_ITEM.get()) {
                String biome = BiomeAbsorberTileEntity.getBiome(stack);
                if (Objects.equals(desiredKey, biome)) {
                    return BiomeAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else if (stack.func_77973_b() == EssencesModule.BLOCK_ABSORBER_ITEM.get()) {
                String block = BlockAbsorberTileEntity.getBlock(stack);
                if (Objects.equals(desiredKey, block)) {
                    return BlockAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else if (stack.func_77973_b() == EssencesModule.FLUID_ABSORBER_ITEM.get()) {
                String fluid = FluidAbsorberTileEntity.getFluid(stack);
                if (Objects.equals(desiredKey, fluid)) {
                    return FluidAbsorberTileEntity.getProgress(stack) >= 100;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean isOwnerDimlet(DimletKey dimletKey) {
        return dimletKey != null && dimletKey.getType() == DimletType.ADMIN && dimletKey.getKey().equals(AdminDimletType.OWNER.name().toLowerCase());
    }

    public static boolean isValidDimlet(DimletKey key) {
        switch (key.getType()) {
            case BIOME: {
                return ForgeRegistries.BIOMES.getValue(new ResourceLocation(key.getKey())) != null;
            }
            case BLOCK: {
                Block value = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(key.getKey()));
                return value != null && value != Blocks.field_150350_a;
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(key.getKey()));
                return fluid != null && fluid.func_207188_f().func_206883_i().func_177230_c() != Blocks.field_150350_a;
            }
        }
        return true;
    }
}

