/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimlets.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.network.PacketBuffer;

public class DimletClientHelper {
    public static long dimletListAge = 0L;
    public static List<DimletWithInfo> dimlets = new ArrayList<DimletWithInfo>();

    public static void setDimletsOnGui(List<DimletWithInfo> dimlets) {
        DimletClientHelper.dimlets = dimlets;
        ++dimletListAge;
    }

    public static class DimletWithInfo
    implements Comparable<DimletWithInfo> {
        private final DimletKey dimlet;
        private final boolean craftable;

        public DimletWithInfo(DimletKey dimlet, boolean craftable) {
            this.dimlet = dimlet;
            this.craftable = craftable;
        }

        public DimletKey getDimlet() {
            return this.dimlet;
        }

        public boolean isCraftable() {
            return this.craftable;
        }

        @Override
        public int compareTo(DimletWithInfo o) {
            return this.getDimlet().compareTo(o.getDimlet());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DimletWithInfo that = (DimletWithInfo)o;
            return this.craftable == that.craftable && Objects.equals(this.dimlet, that.dimlet);
        }

        public int hashCode() {
            return Objects.hash(this.dimlet, this.craftable);
        }

        public static class Serializer
        implements ISerializer<DimletWithInfo> {
            public Function<PacketBuffer, DimletWithInfo> getDeserializer() {
                return buf -> {
                    short idx = buf.readShort();
                    DimletType type = DimletType.values()[idx];
                    String key = buf.func_150789_c(Short.MAX_VALUE);
                    DimletKey dimlet1 = new DimletKey(type, key);
                    boolean craftable1 = buf.readBoolean();
                    return new DimletWithInfo(dimlet1, craftable1);
                };
            }

            public BiConsumer<PacketBuffer, DimletWithInfo> getSerializer() {
                return (buf, info) -> {
                    DimletKey dimlet1 = info.getDimlet();
                    buf.writeShort(dimlet1.getType().ordinal());
                    buf.func_180714_a(dimlet1.getKey());
                    buf.writeBoolean(info.isCraftable());
                };
            }
        }
    }
}

