/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensioneditor.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsUtilityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.modules.dimensionbuilder.blocks.DimensionBuilderTileEntity;
import mcjty.rftoolsdim.modules.dimensioneditor.DimensionEditorConfig;
import mcjty.rftoolsdim.modules.dimensioneditor.DimensionEditorModule;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import mcjty.rftoolsdim.modules.dimlets.data.DimletTools;
import mcjty.rftoolsdim.modules.dimlets.data.DimletType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionEditorTileEntity
extends TickingTileEntity {
    public static final EnumProperty<DimensionBuilderTileEntity.OperationType> OPERATIONTYPE = EnumProperty.func_177709_a((String)"operationtype", DimensionBuilderTileEntity.OperationType.class);
    public static final int SLOT_INJECTINPUT = 0;
    public static final int SLOT_DIMENSIONTARGET = 1;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(2).slot(SlotDefinition.specific(DimensionEditorTileEntity::isValidInput).in().out(), 0, 64, 24).slot(SlotDefinition.specific(DimensionBuilderTileEntity::isRealizedTab).in().out(), 1, 118, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 1) {
            return DimensionBuilderTileEntity.isRealizedTab(stack);
        }
        return DimensionEditorTileEntity.isValidInput(stack);
    }).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)DimensionEditorConfig.EDITOR_MAXENERGY.get()).intValue(), (long)((Integer)DimensionEditorConfig.EDITOR_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimension Editor").containerSupplier(DefaultContainerProvider.container(DimensionEditorModule.CONTAINER_DIMENSION_EDITOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((TileEntity)this);
    @GuiValue
    private int editPercentage = 0;
    private int ticksLeft = -1;
    private int ticksCost = -1;
    private int rfPerTick = -1;
    private int state = 0;

    public DimensionEditorTileEntity() {
        super((TileEntityType)DimensionEditorModule.TYPE_DIMENSION_EDITOR.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(DimensionEditorTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/dimension_editor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }

            protected void func_206840_a(@Nonnull StateContainer.Builder<Block, BlockState> builder) {
                super.func_206840_a(builder);
                builder.func_206894_a(new Property[]{OPERATIONTYPE});
            }
        };
    }

    private static boolean isValidInput(ItemStack s) {
        return "rftoolsutility:matter_receiver".equals(s.func_77973_b().getRegistryName().toString());
    }

    public int getEditPercentage() {
        return this.editPercentage;
    }

    public void tickServer() {
        this.editPercentage = this.ticksLeft == -1 ? 0 : (this.ticksCost - this.ticksLeft) * 100 / this.ticksCost;
        ItemStack injectableItemStack = this.validateInjectableItemStack();
        if (injectableItemStack.func_190926_b()) {
            return;
        }
        ItemStack dimensionItemStack = this.validateDimensionItemStack();
        if (dimensionItemStack.func_190926_b()) {
            return;
        }
        if (this.ticksLeft == -1) {
            String dimension = dimensionItemStack.func_196082_o().func_74779_i("dimension");
            ResourceLocation id = new ResourceLocation(dimension);
            DimensionData data = PersistantDimensionManager.get(this.field_145850_b).getData(id);
            if (this.isMatterReceiver(injectableItemStack)) {
                this.ticksCost = 1000;
                this.rfPerTick = 200;
            } else if (this.isTNT(injectableItemStack)) {
                this.ticksCost = 600;
                this.rfPerTick = 10;
            } else {
                DimletKey key = DimletTools.getDimletKey(injectableItemStack);
                DimletSettings settings = DimletDictionary.get().getSettings(key);
                this.ticksCost = 1000 + settings.getTickCost();
                this.rfPerTick = 200 + settings.getCreateCost();
            }
            this.ticksLeft = this.ticksCost;
        } else {
            long rf = this.energyStorage.getEnergyStored();
            int rfpt = this.rfPerTick;
            if (rf >= (long)(rfpt = (int)((float)rfpt * (2.0f - this.infusable.getInfusedFactor()) / 2.0f))) {
                this.energyStorage.consumeEnergy((long)rfpt);
                --this.ticksLeft;
                if (this.ticksLeft <= 0) {
                    String dimension = dimensionItemStack.func_196082_o().func_74779_i("dimension");
                    ResourceLocation id = new ResourceLocation(dimension);
                    DimensionData data = PersistantDimensionManager.get(this.field_145850_b).getData(id);
                    if (this.isMatterReceiver(injectableItemStack)) {
                        Item item;
                        ServerWorld dimWorld = LevelTools.getLevel((World)this.field_145850_b, (RegistryKey)LevelTools.getId((ResourceLocation)id));
                        int y = this.findGoodReceiverLocation((World)dimWorld);
                        if (y == -1) {
                            y = dimWorld.func_234938_ad_() / 2;
                        }
                        if ((item = injectableItemStack.func_77973_b()) instanceof BlockItem) {
                            BlockItem itemBlock = (BlockItem)item;
                            BlockState state = itemBlock.func_179223_d().func_176223_P();
                            BlockPos pos = new BlockPos(8, y, 8);
                            dimWorld.func_180501_a(pos, state, 2);
                            Block block = dimWorld.func_180495_p(pos).func_177230_c();
                            String name = (String)NBTTools.getInfoNBT((ItemStack)injectableItemStack, CompoundNBT::func_74779_i, (String)"tpName", (Object)"");
                            long energy = (Long)NBTTools.getBlockEntityNBT((ItemStack)injectableItemStack, CompoundNBT::func_74763_f, (String)"Energy", (Object)0L);
                            RFToolsUtilityCompat.createTeleporter((ISeedReader)dimWorld, pos, name, (int)energy);
                            block.func_180633_a((World)dimWorld, pos, state, null, injectableItemStack);
                            dimWorld.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
                            dimWorld.func_180501_a(pos.func_177981_b(2), Blocks.field_150350_a.func_176223_P(), 2);
                        }
                    } else if (this.isTNT(injectableItemStack)) {
                        this.safeDeleteDimension(id, dimensionItemStack);
                    } else {
                        DimletKey dimletKey = DimletTools.getDimletKey(injectableItemStack);
                    }
                    this.items.decrStackSize(0, 1);
                    this.stopInjecting();
                }
            }
        }
        this.func_70296_d();
        this.setState();
    }

    private void safeDeleteDimension(ResourceLocation id, ItemStack dimensionTab) {
    }

    private int findGoodReceiverLocation(World dimWorld) {
        int y = DimensionEditorTileEntity.findSuitableEmptySpot(dimWorld, 8, 8);
        return ++y;
    }

    public static int findSuitableEmptySpot(World world, int x, int z) {
        int y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        if (y == -1) {
            return -1;
        }
        if (y == 0) {
            y = 65;
        }
        if (--y > world.func_234938_ad_() - 5) {
            y = world.func_234938_ad_() / 2;
        }
        BlockState state = world.func_180495_p(new BlockPos(x, y + 1, z));
        while (state.func_185904_a().func_76224_d()) {
            if (++y > world.func_234938_ad_() - 10) {
                return -1;
            }
            state = world.func_180495_p(new BlockPos(x, y + 1, z));
        }
        return y;
    }

    private ItemStack validateInjectableItemStack() {
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        if (this.isMatterReceiver(itemStack)) {
            return itemStack;
        }
        if (this.isTNT(itemStack)) {
            return this.canDeleteDimension(itemStack);
        }
        DimletKey key = DimletTools.getDimletKey(itemStack);
        DimletType type = key.getType();
        return ItemStack.field_190927_a;
    }

    private ItemStack canDeleteDimension(ItemStack itemStack) {
        return ItemStack.field_190927_a;
    }

    private boolean isMatterReceiver(ItemStack itemStack) {
        return "rftoolsutility:matter_receiver".equals(itemStack.func_77973_b().getRegistryName().toString());
    }

    private boolean isTNT(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_221649_bM;
    }

    private ItemStack validateDimensionItemStack() {
        ItemStack itemStack = this.items.getStackInSlot(1);
        if (itemStack.func_190926_b()) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        String dimension = itemStack.func_196082_o().func_74779_i("dimension");
        ResourceLocation id = new ResourceLocation(dimension);
        DimensionData data = PersistantDimensionManager.get(this.field_145850_b).getData(id);
        if (data == null) {
            this.stopInjecting();
            return ItemStack.field_190927_a;
        }
        return itemStack;
    }

    private void stopInjecting() {
        this.setState();
        this.ticksLeft = -1;
        this.ticksCost = -1;
        this.rfPerTick = -1;
        this.func_70296_d();
    }

    private void setState() {
        int oldstate = this.state;
        this.state = 0;
        this.state = this.ticksLeft == 0 ? 0 : (this.ticksLeft == -1 ? 1 : ((this.ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(OPERATIONTYPE, (Comparable)((Object)DimensionBuilderTileEntity.OperationType.values()[this.state])), 11);
            this.func_70296_d();
        }
    }
}

