/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.modules.dimensionbuilder.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsdim.compat.RFToolsUtilityCompat;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionManager;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.power.PowerHandler;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderConfig;
import mcjty.rftoolsdim.modules.dimensionbuilder.DimensionBuilderModule;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class DimensionBuilderTileEntity
extends TickingTileEntity {
    @GuiValue
    private int errorMode = 0;
    public static final int SLOT_DIMENSION_TAB = 0;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(1).slot(SlotDefinition.specific(DimensionBuilderTileEntity::isRealizedTab).in().out(), 0, 28, 24).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> DimensionBuilderTileEntity.isRealizedTab(stack)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)DimensionBuilderConfig.BUILDER_MAXENERGY.get()).intValue(), (long)((Integer)DimensionBuilderConfig.BUILDER_RECEIVEPERTICK.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Dimension Builder").containerSupplier(DefaultContainerProvider.container(DimensionBuilderModule.CONTAINER_DIMENSION_BUILDER, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).integerListener(Sync.integer(this::getBuildPercentage, v -> {
        this.clientBuildPercentage = v;
    })).setupSync((GenericTileEntity)this));
    @Cap(type=CapType.INFUSABLE)
    private final LazyOptional<IInfusable> infusableHandler = LazyOptional.of(() -> new DefaultInfusable((TileEntity)this));
    private int clientBuildPercentage = 0;
    private int state = 0;
    public static final short OK = 0;
    public static final short ERROR_NOOWNER = -1;
    public static final short ERROR_TOOMANYDIMENSIONS = -2;
    public static final short ERROR_COLLISION = -3;
    private static final Random random = new Random();

    public DimensionBuilderTileEntity() {
        super((TileEntityType)DimensionBuilderModule.TYPE_DIMENSION_BUILDER.get());
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().tileEntitySupplier(DimensionBuilderTileEntity::new).infusable().manualEntry(ManualHelper.create((String)"rftoolsdim:dimensions/dimension_builder")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsdim.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()})){

            public RotationType getRotationType() {
                return RotationType.ROTATION;
            }
        };
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.saveClientDataToNBT(nbtTag);
        nbtTag.func_74768_a("errorMode", this.errorMode);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, nbtTag);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        updateTag.func_74768_a("errorMode", this.errorMode);
        return updateTag;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        int oldstate = this.state;
        int oldError = this.errorMode;
        super.onDataPacket(net, packet);
        this.errorMode = (short)packet.func_148857_g().func_74762_e("errorMode");
        if (oldstate != this.state || oldError != this.errorMode) {
            this.func_145831_w().func_225319_b(this.field_174879_c, this.func_195044_w(), this.func_195044_w());
        }
    }

    public void tickServer() {
        CompoundNBT tagCompound = this.hasTab();
        if (tagCompound == null) {
            this.setState(-1);
            return;
        }
        if (!this.isMachineEnabled()) {
            this.setState(-1);
            return;
        }
        int ticksLeft = tagCompound.func_74762_e("ticksLeft");
        if (ticksLeft > 0) {
            ticksLeft = this.createDimensionTick(tagCompound, ticksLeft);
        } else {
            this.maintainDimensionTick(tagCompound);
        }
        this.setState(ticksLeft);
    }

    private void maintainDimensionTick(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("dimension")) {
            String dimension = tagCompound.func_74779_i("dimension");
            ResourceLocation id = new ResourceLocation(dimension);
            DimensionData data = PersistantDimensionManager.get(this.field_145850_b).getData(id);
            if (data == null) {
                return;
            }
            long rf = this.energyStorage.getEnergy();
            long energy = data.getEnergy();
            long maxEnergy = PowerHandler.calculateMaxDimensionPower(id, this.field_145850_b) - energy;
            if (rf > maxEnergy) {
                rf = maxEnergy;
            }
            this.energyStorage.consumeEnergy(rf);
            data.setEnergy(this.field_145850_b, energy + rf);
            PersistantDimensionManager.get(this.field_145850_b).save();
        }
    }

    private int createDimensionTick(CompoundNBT tagCompound, int ticksLeft) {
        this.errorMode = 0;
        String name = tagCompound.func_74779_i("name");
        DimensionManager.get().markReservedName(this.field_145850_b, this.field_174879_c, name);
        int createCost = tagCompound.func_74762_e("rfCreateCost");
        Float inf = this.infusableHandler.map(IInfusable::getInfusedFactor).orElse(Float.valueOf(0.0f));
        createCost = (int)((float)createCost * (2.0f - inf.floatValue()) / 2.0f);
        if (this.isCheaterDimension(tagCompound) || this.energyStorage.getEnergyStored() >= createCost) {
            if (!DimensionManager.get().isNameAvailable(this.field_145850_b, this.field_174879_c, name)) {
                this.errorMode = -3;
                this.func_70296_d();
                return ticksLeft;
            }
            if (this.isCheaterDimension(tagCompound)) {
                ticksLeft = 0;
            } else {
                this.energyStorage.consumeEnergy((long)createCost);
                --ticksLeft;
                if (random.nextFloat() < inf.floatValue() && --ticksLeft < 0) {
                    ticksLeft = 0;
                }
            }
            tagCompound.func_74768_a("ticksLeft", ticksLeft);
            if (ticksLeft <= 0) {
                String descriptorString = tagCompound.func_74779_i("descriptor");
                DimensionDescriptor descriptor = new DimensionDescriptor();
                descriptor.read(descriptorString);
                DimensionDescriptor randomizedDescriptor = descriptor.createRandomizedDescriptor(random);
                if (!DimensionManager.get().isNameAvailable(this.field_145850_b, this.field_174879_c, name)) {
                    this.errorMode = -3;
                    this.func_70296_d();
                    return 0;
                }
                if (!DimensionManager.get().isDescriptorAvailable(this.field_145850_b, descriptor)) {
                    this.errorMode = -3;
                    this.func_70296_d();
                    return 0;
                }
                long seed = random.nextLong();
                ServerWorld newworld = DimensionManager.get().createWorld(this.field_145850_b, name, seed, descriptor, randomizedDescriptor);
                ResourceLocation id = new ResourceLocation("rftoolsdim", name);
                tagCompound.func_74778_a("dimension", id.toString());
                CompiledDescriptor compiledDescriptor = DimensionManager.get().getCompiledDescriptor((World)newworld);
                tagCompound.func_74768_a("rfMaintainCost", compiledDescriptor.getActualPowerCost());
                this.func_70296_d();
                this.placeMatterReceiver(newworld, name);
            }
        }
        return ticksLeft;
    }

    private void placeMatterReceiver(ServerWorld newworld, String name) {
        for (int y = 250; y >= 1; --y) {
            if (newworld.func_180495_p(new BlockPos(8, y, 8)).func_177230_c() != Blocks.field_150483_bI) continue;
            RFToolsUtilityCompat.createTeleporter((ISeedReader)newworld, new BlockPos(8, y, 8), name);
            return;
        }
        int platformHeight = DimensionManager.get().getPlatformHeight(newworld.func_234923_W_().func_240901_a_());
        RFToolsUtilityCompat.createTeleporter((ISeedReader)newworld, new BlockPos(8, platformHeight, 8), name);
        newworld.func_175656_a(new BlockPos(8, platformHeight + 1, 8), Blocks.field_150350_a.func_176223_P());
        newworld.func_175656_a(new BlockPos(8, platformHeight + 2, 8), Blocks.field_150350_a.func_176223_P());
    }

    private boolean isCheaterDimension(CompoundNBT tag) {
        return false;
    }

    public OperationType getState() {
        return OperationType.values()[this.state];
    }

    private void setState(int ticksLeft) {
        int oldstate = this.state;
        this.state = ticksLeft == 0 ? 0 : (ticksLeft == -1 ? 1 : ((ticksLeft >> 2 & 1) == 0 ? 2 : 3));
        if (oldstate != this.state) {
            this.func_70296_d();
        }
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
        this.loadItemHandlerCap(tagCompound);
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
        this.saveItemHandlerCap(tagCompound);
    }

    public CompoundNBT hasTab() {
        ItemStack itemStack = this.items.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return null;
        }
        return itemStack.func_77978_p();
    }

    public int getBuildPercentage() {
        if (this.field_145850_b.field_72995_K) {
            return this.clientBuildPercentage;
        }
        CompoundNBT tag = this.hasTab();
        if (tag != null) {
            int ticksLeft = tag.func_74762_e("ticksLeft");
            int tickCost = tag.func_74762_e("tickCost");
            if (tickCost == 0) {
                return 0;
            }
            return (tickCost - ticksLeft) * 100 / tickCost;
        }
        return 0;
    }

    public int getErrorMode() {
        return this.errorMode;
    }

    public static boolean isRealizedTab(ItemStack stack) {
        return stack.func_77973_b() == DimensionBuilderModule.REALIZED_DIMENSION_TAB.get();
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public static enum OperationType implements IStringSerializable
    {
        CHARGING("charging"),
        EMPTY("empty"),
        BUILDING1("building1"),
        BUILDING2("building2");

        private final String name;

        private OperationType(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

