/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.descriptor;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.rftoolsdim.dimension.AdminDimletType;
import mcjty.rftoolsdim.dimension.DimensionConfig;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.biomes.BiomeControllerType;
import mcjty.rftoolsdim.dimension.descriptor.CompiledFeature;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.features.FeatureType;
import mcjty.rftoolsdim.dimension.terraintypes.AttributeType;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.modules.dimlets.data.DimletDictionary;
import mcjty.rftoolsdim.modules.dimlets.data.DimletKey;
import mcjty.rftoolsdim.modules.dimlets.data.DimletSettings;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CompiledDescriptor {
    private TerrainType terrainType = null;
    private final Set<AttributeType> attributeTypes = EnumSet.noneOf(AttributeType.class);
    private final List<BlockState> baseBlocks = new ArrayList<BlockState>();
    private BlockState baseLiquid = null;
    private final Set<AdminDimletType> adminDimletTypes = EnumSet.noneOf(AdminDimletType.class);
    private final Set<CompiledFeature> features = new HashSet<CompiledFeature>();
    private BiomeControllerType biomeControllerType = null;
    private final List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    private TimeType timeType = null;
    private int createCostPerTick = 0;
    private int maintainCostPerTick = 0;
    private int randomizedCostPerTick = 0;
    private int actualTickCost = 0;

    @Nonnull
    public DescriptorError compile(DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor) {
        this.createCostPerTick = 10;
        this.maintainCostPerTick = 10;
        this.randomizedCostPerTick = 0;
        this.actualTickCost = 100;
        ArrayList<BlockState> collectedBlocks = new ArrayList<BlockState>();
        ArrayList<BlockState> collectedFluids = new ArrayList<BlockState>();
        EnumSet<AttributeType> collectedAttributes = EnumSet.noneOf(AttributeType.class);
        for (DimletKey dimlet : descriptor.getDimlets()) {
            DescriptorError error = this.handleDimlet(collectedBlocks, collectedFluids, collectedAttributes, dimlet);
            if (error == null) continue;
            return error;
        }
        int originalMaintainCost = this.maintainCostPerTick;
        this.maintainCostPerTick = 0;
        for (DimletKey dimlet : randomizedDescriptor.getDimlets()) {
            DescriptorError error = this.handleDimlet(collectedBlocks, collectedFluids, collectedAttributes, dimlet);
            if (error == null) continue;
            return error;
        }
        this.randomizedCostPerTick = (int)((double)this.maintainCostPerTick * (Double)DimensionConfig.RANDOMIZED_DIMLET_COST_FACTOR.get());
        this.maintainCostPerTick = originalMaintainCost;
        if (this.adminDimletTypes.contains((Object)AdminDimletType.CHEATER)) {
            this.createCostPerTick = 0;
            this.maintainCostPerTick = 0;
            this.randomizedCostPerTick = 0;
            this.actualTickCost = 1;
        }
        if (!collectedBlocks.isEmpty()) {
            return DescriptorError.ERROR(DescriptorError.Code.DANGLING_BLOCKS);
        }
        if (!collectedFluids.isEmpty()) {
            return DescriptorError.ERROR(DescriptorError.Code.DANGLING_FLUIDS);
        }
        if (!collectedAttributes.isEmpty()) {
            return DescriptorError.ERROR(DescriptorError.Code.DANGLING_ATTRIBUTES);
        }
        return DescriptorError.OK;
    }

    public void complete() {
        if (this.terrainType == null) {
            this.terrainType = TerrainType.NORMAL;
        }
        if (this.timeType == null) {
            this.timeType = TimeType.NORMAL;
        }
        if (this.biomeControllerType == null) {
            this.biomeControllerType = BiomeControllerType.SINGLE;
        }
        if (this.baseBlocks.isEmpty()) {
            this.baseBlocks.add(Blocks.field_150348_b.func_176223_P());
        }
        if (this.baseLiquid == null) {
            this.baseLiquid = Blocks.field_150355_j.func_176223_P();
        }
    }

    private DescriptorError handleDimlet(List<BlockState> collectedBlocks, List<BlockState> collectedFluids, Set<AttributeType> collectedAttributes, DimletKey dimlet) {
        DimletSettings settings = DimletDictionary.get().getSettings(dimlet);
        if (settings != null) {
            this.createCostPerTick += settings.getCreateCost();
            this.actualTickCost += settings.getTickCost();
            this.maintainCostPerTick += settings.getMaintainCost();
        }
        String name = dimlet.getKey();
        switch (dimlet.getType()) {
            case TERRAIN: {
                if (this.terrainType != null) {
                    return DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_TERRAIN);
                }
                this.terrainType = TerrainType.byName(name);
                if (this.terrainType == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_TERRAIN_TYPE, name);
                }
                this.baseBlocks.addAll(collectedBlocks);
                collectedBlocks.clear();
                if (this.baseBlocks.isEmpty()) {
                    this.baseBlocks.add(Blocks.field_150348_b.func_176223_P());
                }
                this.attributeTypes.addAll(collectedAttributes);
                collectedAttributes.clear();
                if (collectedFluids.size() > 1) {
                    return DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_FLUID, name);
                }
                if (collectedFluids.size() != 1) break;
                this.baseLiquid = collectedFluids.get(0);
                collectedFluids.clear();
                break;
            }
            case ATTRIBUTE: {
                AttributeType type = AttributeType.byName(dimlet.getKey());
                if (type == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_ATTRIBUTE, name);
                }
                collectedAttributes.add(type);
                break;
            }
            case DIGIT: {
                break;
            }
            case ADMIN: {
                AdminDimletType type = AdminDimletType.byName(dimlet.getKey());
                if (type == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_ADMIN_TYPE, name);
                }
                this.adminDimletTypes.add(type);
                break;
            }
            case BIOME_CONTROLLER: {
                if (this.biomeControllerType != null) {
                    return DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_BIOME_CONTROLLER);
                }
                this.biomeControllerType = BiomeControllerType.byName(name);
                if (this.biomeControllerType != null) break;
                return DescriptorError.ERROR(DescriptorError.Code.BAD_BIOME_CONTROLLER, name);
            }
            case BIOME: {
                this.biomes.add(new ResourceLocation(name));
                break;
            }
            case TIME: {
                if (this.timeType != null) {
                    return DescriptorError.ERROR(DescriptorError.Code.ONLY_ONE_TIME);
                }
                this.timeType = TimeType.byName(name);
                if (this.timeType != null) break;
                return DescriptorError.ERROR(DescriptorError.Code.BAD_TIME, name);
            }
            case FEATURE: {
                FeatureType feature = FeatureType.byName(name);
                if (feature == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_FEATURE, name);
                }
                CompiledFeature compiledFeature = new CompiledFeature(feature);
                compiledFeature.getBlocks().addAll(collectedBlocks);
                collectedBlocks.clear();
                if (compiledFeature.getBlocks().isEmpty()) {
                    compiledFeature.getBlocks().add(Blocks.field_150348_b.func_176223_P());
                }
                compiledFeature.getFluids().addAll(collectedFluids);
                collectedFluids.clear();
                if (compiledFeature.getFluids().isEmpty()) {
                    compiledFeature.getFluids().add(Blocks.field_150355_j.func_176223_P());
                }
                this.features.add(compiledFeature);
                break;
            }
            case BLOCK: {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name));
                if (block == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_BLOCK, name);
                }
                collectedBlocks.add(block.func_176223_P());
                break;
            }
            case FLUID: {
                Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(name));
                if (fluid == null) {
                    return DescriptorError.ERROR(DescriptorError.Code.BAD_FLUID, name);
                }
                BlockState blockState = fluid.func_207188_f().func_206883_i();
                if (blockState != null && !blockState.func_196958_f()) {
                    collectedFluids.add(blockState);
                    break;
                }
                return DescriptorError.ERROR(DescriptorError.Code.FLUID_HAS_NO_BLOCK, name);
            }
        }
        return null;
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public TerrainType getTerrainType() {
        return this.terrainType;
    }

    public Set<AttributeType> getAttributeTypes() {
        return this.attributeTypes;
    }

    public Set<AdminDimletType> getAdminDimletTypes() {
        return this.adminDimletTypes;
    }

    public BlockState getBaseLiquid() {
        return this.baseLiquid;
    }

    public int getCreateCostPerTick() {
        return this.createCostPerTick;
    }

    public int getActualTickCost() {
        return this.actualTickCost;
    }

    public int getActualPowerCost() {
        return this.maintainCostPerTick + this.randomizedCostPerTick;
    }

    public int getMaintainCostPerTick() {
        return this.maintainCostPerTick;
    }

    public List<BlockState> getBaseBlocks() {
        return this.baseBlocks;
    }

    public Set<CompiledFeature> getFeatures() {
        return this.features;
    }

    public BiomeControllerType getBiomeControllerType() {
        return this.biomeControllerType;
    }

    public List<ResourceLocation> getBiomes() {
        return this.biomes;
    }
}

