/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimension.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsdim.RFToolsDim;
import mcjty.rftoolsdim.dimension.TimeType;
import mcjty.rftoolsdim.dimension.data.DimensionData;
import mcjty.rftoolsdim.dimension.data.DimensionSettings;
import mcjty.rftoolsdim.dimension.data.PersistantDimensionManager;
import mcjty.rftoolsdim.dimension.descriptor.CompiledDescriptor;
import mcjty.rftoolsdim.dimension.descriptor.DescriptorError;
import mcjty.rftoolsdim.dimension.descriptor.DimensionDescriptor;
import mcjty.rftoolsdim.dimension.terraintypes.BaseChunkGenerator;
import mcjty.rftoolsdim.dimension.terraintypes.TerrainType;
import mcjty.rftoolsdim.dimension.tools.DimensionHelper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DimensionManager {
    private final Map<ResourceLocation, CompiledDescriptor> compiledDescriptorMap = new HashMap<ResourceLocation, CompiledDescriptor>();
    private final Map<ResourceLocation, Integer> platformHeightMap = new HashMap<ResourceLocation, Integer>();
    private final Map<String, ReservedName> reservedDimensionNames = new HashMap<String, ReservedName>();
    private static final DimensionManager instance = new DimensionManager();

    public static DimensionManager get() {
        return instance;
    }

    public void clear() {
        this.platformHeightMap.clear();
        this.compiledDescriptorMap.clear();
    }

    public CompiledDescriptor getCompiledDescriptor(@Nullable World world) {
        if (world == null) {
            return null;
        }
        RegistryKey type = world.func_234923_W_();
        ResourceLocation id = type.func_240901_a_();
        return this.getCompiledDescriptor(world, id);
    }

    public CompiledDescriptor getCompiledDescriptor(World overworld, ResourceLocation id) {
        if (!this.compiledDescriptorMap.containsKey(id)) {
            ServerWorld world = LevelTools.getLevel((World)overworld, (ResourceLocation)id);
            if (world == null) {
                return null;
            }
            ChunkGenerator generator = world.func_72863_F().field_186029_c;
            if (generator instanceof BaseChunkGenerator) {
                CompiledDescriptor compiledDescriptor = ((BaseChunkGenerator)generator).getDimensionSettings().getCompiledDescriptor();
                this.compiledDescriptorMap.put(id, compiledDescriptor);
            } else {
                RFToolsDim.setup.getLogger().error(id.toString() + " is not a dimension managed by us!");
                return null;
            }
        }
        return this.compiledDescriptorMap.get(id);
    }

    public void markReservedName(World world, BlockPos pos, String name) {
        this.reservedDimensionNames.put(name, new ReservedName(world, pos, System.currentTimeMillis()));
    }

    public World getDimWorld(String name) {
        ResourceLocation id = new ResourceLocation(name);
        RegistryKey type = LevelTools.getId((ResourceLocation)id);
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(type);
        if (world == null && !name.contains(":")) {
            id = new ResourceLocation("rftoolsdim", name);
            type = LevelTools.getId((ResourceLocation)id);
            return ServerLifecycleHooks.getCurrentServer().func_71218_a(type);
        }
        return world;
    }

    public boolean isNameAvailable(World world, @Nullable BlockPos pos, String name) {
        long currentTime = System.currentTimeMillis();
        ReservedName reservedName = this.reservedDimensionNames.get(name);
        if (!(reservedName == null || currentTime >= reservedName.reservationTime + 10000L || reservedName.pos.equals((Object)pos) && reservedName.world.equals(world.func_234923_W_()))) {
            return false;
        }
        ResourceLocation id = new ResourceLocation("rftoolsdim", name);
        PersistantDimensionManager mgr = PersistantDimensionManager.get(world);
        DimensionData data = mgr.getData(id);
        return data == null;
    }

    public boolean isDescriptorAvailable(World world, DimensionDescriptor descriptor) {
        PersistantDimensionManager mgr = PersistantDimensionManager.get(world);
        DimensionData data = mgr.getData(descriptor);
        return data == null;
    }

    public ServerWorld createWorld(World world, String name, long seed, DimensionDescriptor descriptor, DimensionDescriptor randomizedDescriptor) {
        ResourceLocation id = new ResourceLocation("rftoolsdim", name);
        PersistantDimensionManager mgr = PersistantDimensionManager.get(world);
        DimensionData data = mgr.getData(id);
        if (data != null) {
            RFToolsDim.setup.getLogger().error("There is already a dimension with this id: " + name);
            throw new RuntimeException("There is already a dimension with this id: " + name);
        }
        data = mgr.getData(descriptor);
        if (data != null) {
            RFToolsDim.setup.getLogger().error("There is already a dimension with this descriptor: " + name);
            throw new RuntimeException("There is already a dimension with this descriptor: " + name);
        }
        CompiledDescriptor compiledDescriptor = new CompiledDescriptor();
        DescriptorError error = compiledDescriptor.compile(descriptor, randomizedDescriptor);
        if (!error.isOk()) {
            RFToolsDim.setup.getLogger().error("Error compiling dimension descriptor: " + error.getMessage());
            throw new RuntimeException("Error compiling dimension descriptor: " + error.getMessage());
        }
        compiledDescriptor.complete();
        TerrainType terrainType = compiledDescriptor.getTerrainType();
        DimensionSettings settings = new DimensionSettings(seed, descriptor.compact(), randomizedDescriptor.compact());
        TimeType timeType = compiledDescriptor.getTimeType();
        RegistryKey key = LevelTools.getId((ResourceLocation)id);
        DimensionType type = (DimensionType)world.func_73046_m().func_244267_aX().func_243612_b(Registry.field_239698_ad_).func_82594_a(timeType.getDimensionType());
        ServerWorld result = DimensionHelper.getOrCreateWorld(world.func_73046_m(), (RegistryKey<World>)key, (server, registryKey) -> new Dimension(() -> type, terrainType.getGeneratorSupplier().apply((MinecraftServer)server, settings)));
        data = new DimensionData(id, descriptor, randomizedDescriptor);
        mgr.register(data);
        return result;
    }

    public String createDimension(World world, String name, long seed, String filename) {
        RegistryKey id = LevelTools.getId((ResourceLocation)new ResourceLocation("rftoolsdim", name));
        if (world.func_73046_m().func_71218_a(id) != null) {
            return "Dimension already exists!";
        }
        DimensionDescriptor descriptor = new DimensionDescriptor();
        if (!filename.endsWith(".json")) {
            filename = filename + ".json";
        }
        try (InputStream inputstream = RFToolsDim.class.getResourceAsStream("/data/rftoolsdim/rftdim/" + filename);
             BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
            JsonParser parser = new JsonParser();
            JsonElement element = parser.parse((Reader)br);
            descriptor.read(element.getAsJsonArray());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.createWorld(world, name, seed, descriptor, DimensionDescriptor.EMPTY);
        return null;
    }

    public void registerPlatformHeight(ResourceLocation location, int floorHeight) {
        this.platformHeightMap.put(location, floorHeight);
    }

    public int getPlatformHeight(ResourceLocation location) {
        return this.platformHeightMap.getOrDefault(location, 65);
    }

    private static class ReservedName {
        private long reservationTime;
        private final BlockPos pos;
        private final RegistryKey<World> world;

        public ReservedName(World world, BlockPos pos, long reservationTime) {
            this.pos = pos;
            this.world = world.func_234923_W_();
            this.reservationTime = reservationTime;
        }
    }
}

