/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;

public class PixieAISteal
extends Goal {
    private final EntityPixie temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private PlayerEntity temptingPlayer;
    private int delayTemptCounter = 0;
    private boolean isRunning;

    public PixieAISteal(EntityPixie temptedEntityIn, double speedIn) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
    }

    public boolean func_75250_a() {
        if (!IafConfig.pixiesStealItems || !this.temptedEntity.func_184614_ca().func_190926_b() || this.temptedEntity.stealCooldown > 0) {
            return false;
        }
        if (this.temptedEntity.func_70681_au().nextInt(200) == 0) {
            return false;
        }
        if (this.temptedEntity.func_70909_n()) {
            return false;
        }
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.temptingPlayer = this.temptedEntity.field_70170_p.func_217362_a((Entity)this.temptedEntity, 10.0);
        return this.temptingPlayer != null && this.temptedEntity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.temptingPlayer.field_71071_by.func_191420_l() && !this.temptingPlayer.func_184812_l_();
    }

    public boolean func_75253_b() {
        return !this.temptedEntity.func_70909_n() && this.temptedEntity.func_184614_ca().func_190926_b() && this.delayTemptCounter == 0 && this.temptedEntity.stealCooldown == 0;
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.func_226277_ct_();
        this.targetY = this.temptingPlayer.func_226278_cu_();
        this.targetZ = this.temptingPlayer.func_226281_cx_();
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        if (this.delayTemptCounter < 10) {
            this.delayTemptCounter += 10;
        }
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        ArrayList<Integer> slotlist = new ArrayList<Integer>();
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 3.0 && !this.temptingPlayer.field_71071_by.func_191420_l()) {
            for (int i = 0; i < this.temptingPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack targetStack = this.temptingPlayer.field_71071_by.func_70301_a(i);
                if (PlayerInventory.func_184435_e((int)i) || targetStack.func_190926_b() || !targetStack.func_77985_e()) continue;
                slotlist.add(i);
            }
            if (slotlist.size() >= 1) {
                int slot = slotlist.size() == 1 ? ((Integer)slotlist.get(0)).intValue() : ((Integer)slotlist.get(new Random().nextInt(slotlist.size()))).intValue();
                ItemStack randomItem = this.temptingPlayer.field_71071_by.func_70301_a(slot);
                this.temptedEntity.func_184611_a(Hand.MAIN_HAND, randomItem);
                this.temptingPlayer.field_71071_by.func_70304_b(slot);
                this.temptedEntity.flipAI(true);
                this.temptedEntity.func_184185_a(IafSoundRegistry.PIXIE_TAUNT, 1.0f, 1.0f);
                for (EntityPixie pixie : this.temptingPlayer.field_70170_p.func_217357_a(EntityPixie.class, this.temptedEntity.func_174813_aQ().func_186662_g(40.0))) {
                    pixie.stealCooldown = 1000 + pixie.func_70681_au().nextInt(3000);
                }
                if (this.temptingPlayer != null) {
                    this.temptingPlayer.func_195064_c(new EffectInstance(this.temptedEntity.negativePotions[this.temptedEntity.getColor()], 100));
                }
            } else {
                this.temptedEntity.flipAI(true);
                this.delayTemptCounter = 200;
            }
        } else {
            this.temptedEntity.func_70605_aq().func_75642_a(this.temptingPlayer.func_226277_ct_(), this.temptingPlayer.func_226278_cu_() + 1.5, this.temptingPlayer.func_226281_cx_(), 1.0);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

