/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadHorse;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.IDreadMob;
import com.github.alexthe666.iceandfire.entity.util.IHumanoid;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class EntityDreadMob
extends MonsterEntity
implements IDreadMob {
    protected static final DataParameter<Optional<UUID>> COMMANDER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDreadMob.class, (IDataSerializer)DataSerializers.field_187203_m);

    public EntityDreadMob(EntityType t, World worldIn) {
        super(t, worldIn);
    }

    public static Entity necromancyEntity(LivingEntity entity) {
        IDreadMob lichSummoned = null;
        if (entity.func_70668_bt() == CreatureAttribute.field_223224_c_) {
            lichSummoned = new EntityDreadScuttler(IafEntityRegistry.DREAD_SCUTTLER, entity.field_70170_p);
            float readInScale = entity.func_213311_cf() / 1.5f;
            if (entity.field_70170_p instanceof IServerWorld) {
                lichSummoned.func_213386_a((IServerWorld)entity.field_70170_p, entity.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            }
            lichSummoned.setScale(readInScale);
            return lichSummoned;
        }
        if (entity instanceof ZombieEntity || entity instanceof IHumanoid) {
            lichSummoned = new EntityDreadGhoul(IafEntityRegistry.DREAD_GHOUL, entity.field_70170_p);
            float readInScale = entity.func_213311_cf() / 0.6f;
            if (entity.field_70170_p instanceof IServerWorld) {
                ((EntityDreadGhoul)lichSummoned).func_213386_a((IServerWorld)entity.field_70170_p, entity.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            }
            ((EntityDreadGhoul)lichSummoned).setScale(readInScale);
            return lichSummoned;
        }
        if (entity.func_70668_bt() == CreatureAttribute.field_223223_b_ || entity instanceof AbstractSkeletonEntity || entity instanceof PlayerEntity) {
            lichSummoned = new EntityDreadThrall(IafEntityRegistry.DREAD_THRALL, entity.field_70170_p);
            EntityDreadThrall thrall = (EntityDreadThrall)lichSummoned;
            if (entity.field_70170_p instanceof IServerWorld) {
                thrall.func_213386_a((IServerWorld)entity.field_70170_p, entity.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            }
            thrall.setCustomArmorHead(false);
            thrall.setCustomArmorChest(false);
            thrall.setCustomArmorLegs(false);
            thrall.setCustomArmorFeet(false);
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                thrall.func_184201_a(slot, entity.func_184582_a(slot));
            }
            return thrall;
        }
        if (entity instanceof AbstractHorseEntity) {
            lichSummoned = new EntityDreadHorse(IafEntityRegistry.DREAD_HORSE, entity.field_70170_p);
            return lichSummoned;
        }
        if (entity instanceof AnimalEntity) {
            lichSummoned = new EntityDreadBeast(IafEntityRegistry.DREAD_BEAST, entity.field_70170_p);
            float readInScale = entity.func_213311_cf() / 1.2f;
            if (entity.field_70170_p instanceof IServerWorld) {
                ((EntityDreadBeast)lichSummoned).func_213386_a((IServerWorld)entity.field_70170_p, entity.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
            }
            ((EntityDreadBeast)lichSummoned).setScale(readInScale);
            return lichSummoned;
        }
        return lichSummoned;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COMMANDER_UNIQUE_ID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getCommanderId() != null) {
            compound.func_186854_a("CommanderUUID", this.getCommanderId());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        UUID uuid;
        super.func_70037_a(compound);
        if (compound.func_186855_b("CommanderUUID")) {
            uuid = compound.func_186857_a("CommanderUUID");
        } else {
            String s = compound.func_74779_i("CommanderUUID");
            uuid = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setCommanderId(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof IDreadMob || super.func_184191_r(entityIn);
    }

    @Nullable
    public UUID getCommanderId() {
        return ((Optional)this.field_70180_af.func_187225_a(COMMANDER_UNIQUE_ID)).orElse(null);
    }

    public void setCommanderId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(COMMANDER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void func_70636_d() {
        EntityDreadLich lich;
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getCommander() instanceof EntityDreadLich && (lich = (EntityDreadLich)this.getCommander()).func_70638_az() != null && lich.func_70638_az().func_70089_S()) {
            this.func_70624_b(lich.func_70638_az());
        }
    }

    @Override
    public Entity getCommander() {
        try {
            Entity entity;
            PlayerEntity player;
            UUID uuid = this.getCommanderId();
            PlayerEntity playerEntity = player = uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
            if (player != null) {
                return player;
            }
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_70170_p.func_234923_W_()).func_217461_a(uuid)) instanceof LivingEntity) {
                return entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public void onKillEntity(LivingEntity LivingEntityIn) {
        Entity summoned;
        EntityDreadMob commander;
        EntityDreadMob entityDreadMob = commander = this instanceof EntityDreadLich ? this : this.getCommander();
        if (commander != null && !(LivingEntityIn instanceof EntityDragonBase) && (summoned = EntityDreadMob.necromancyEntity(LivingEntityIn)) != null) {
            summoned.func_82149_j((Entity)LivingEntityIn);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c(summoned);
            }
            if (commander instanceof EntityDreadLich) {
                ((EntityDreadLich)commander).setMinionCount(((EntityDreadLich)commander).getMinionCount() + 1);
            }
            if (summoned instanceof EntityDreadMob) {
                ((EntityDreadMob)summoned).setCommanderId(commander.func_110124_au());
            }
        }
    }

    public void func_70106_y() {
        if (!this.field_70128_L && this.getCommander() != null && this.getCommander() instanceof EntityDreadLich) {
            EntityDreadLich lich = (EntityDreadLich)this.getCommander();
            lich.setMinionCount(lich.getMinionCount() - 1);
        }
        super.func_70106_y();
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }
}

