/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.compat.jei;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.compat.jei.firedragonforge.FireDragonForgeCatagory;
import com.github.alexthe666.iceandfire.compat.jei.icedragonforge.IceDragonForgeCatagory;
import com.github.alexthe666.iceandfire.compat.jei.lightningdragonforge.LightningDragonForgeCatagory;
import com.github.alexthe666.iceandfire.enums.EnumSkullType;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.recipe.IafRecipeRegistry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class IceAndFireJEIPlugin
implements IModPlugin {
    public static final ResourceLocation MOD = new ResourceLocation("iceandfire:iceandfire");
    public static final ResourceLocation FIRE_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:fire_dragon_forge");
    public static final ResourceLocation ICE_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:ice_dragon_forge");
    public static final ResourceLocation LIGHTNING_DRAGON_FORGE_ID = new ResourceLocation("iceandfire:lightning_dragon_forge");

    private void addDescription(IRecipeRegistration registry, ItemStack itemStack) {
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{itemStack.func_77977_a() + ".jei_desc"});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(IafRecipeRegistry.FIRE_FORGE_RECIPES, FIRE_DRAGON_FORGE_ID);
        registry.addRecipes(IafRecipeRegistry.ICE_FORGE_RECIPES, ICE_DRAGON_FORGE_ID);
        registry.addRecipes(IafRecipeRegistry.LIGHTNING_FORGE_RECIPES, LIGHTNING_DRAGON_FORGE_ID);
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.FIRE_DRAGON_BLOOD));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.ICE_DRAGON_BLOOD));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.LIGHTNING_DRAGON_BLOOD));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_RED));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BRONZE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_GRAY));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_GREEN));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BLUE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_WHITE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_SAPPHIRE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_SILVER));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_ELECTRIC));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_AMYTHEST));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_COPPER));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGONEGG_BLACK));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_FIRE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_ICE));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.DRAGON_SKULL_LIGHTNING));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.FIRE_STEW));
        this.addDescription(registry, new ItemStack((IItemProvider)IafItemRegistry.FROST_STEW));
        for (EnumSkullType skull : EnumSkullType.values()) {
            this.addDescription(registry, new ItemStack((IItemProvider)skull.skull_item));
        }
        for (ItemStack stack : IafRecipeRegistry.BANNER_ITEMS) {
            registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{"item.iceandfire.custom_banner.jei_desc"});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new FireDragonForgeCatagory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new IceDragonForgeCatagory()});
        registry.addRecipeCategories(new IRecipeCategory[]{new LightningDragonForgeCatagory()});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IafBlockRegistry.DRAGONFORGE_FIRE_CORE), new ResourceLocation[]{FIRE_DRAGON_FORGE_ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IafBlockRegistry.DRAGONFORGE_ICE_CORE), new ResourceLocation[]{ICE_DRAGON_FORGE_ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)IafBlockRegistry.DRAGONFORGE_LIGHTNING_CORE), new ResourceLocation[]{LIGHTNING_DRAGON_FORGE_ID});
    }

    public ResourceLocation getPluginUid() {
        return MOD;
    }
}

