/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static String getModid(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return stack.func_77973_b().getRegistryName().func_110624_b();
        }
        return "";
    }

    public static String getModName(IForgeRegistryEntry<?> entry) {
        ResourceLocation registryName = entry.getRegistryName();
        String modId = registryName == null ? "minecraft" : registryName.func_110624_b();
        return ModList.get().getModContainerById(modId).map(mod -> mod.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modId));
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer, String error) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static <INPUT extends BASE, BASE> void safeConsume(BASE o, Consumer<INPUT> consumer) {
        try {
            consumer.accept(o);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public static <INPUT extends BASE, BASE, RET> RET safeMap(BASE o, Function<INPUT, RET> consumer, String error) {
        try {
            return consumer.apply(o);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(error, e);
        }
    }

    public static String getReadableName(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return Tools.getReadableName(state.func_177230_c().func_185473_a((IBlockReader)world, pos, state));
    }

    public static String getReadableName(ItemStack stack) {
        return stack.func_200301_q().getString();
    }

    @Nullable
    public static BlockState placeStackAt(PlayerEntity player, ItemStack blockStack, World world, BlockPos pos, @Nullable BlockState origState) {
        BlockRayTraceResult trace = new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.UP, pos, false);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(player, Hand.MAIN_HAND, trace));
        if (blockStack.func_77973_b() instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)blockStack.func_77973_b();
            if (origState == null && (origState = itemBlock.func_179223_d().func_196258_a(context)) == null) {
                return null;
            }
            if (itemBlock.func_195942_a(context).func_226246_a_()) {
                blockStack.func_190918_g(1);
            }
            return origState;
        }
        player.func_184611_a(Hand.MAIN_HAND, blockStack);
        player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5);
        blockStack.func_77973_b().func_195939_a((ItemUseContext)context);
        return world.func_180495_p(pos);
    }
}

