/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Key;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;

public class Sync {
    public static IContainerDataListener values(final ResourceLocation id, final GenericTileEntity te) {
        return new IContainerDataListener(){
            private Map<Key, Object> oldValues = new HashMap<Key, Object>();

            @Override
            public ResourceLocation getId() {
                return id;
            }

            private void copyToOld() {
                this.oldValues.clear();
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    this.oldValues.put(value.getKey(), v);
                }
            }

            @Override
            public boolean isDirtyAndClear() {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    Key<?> key = value.getKey();
                    if (this.oldValues.containsKey(key) && Objects.equals(this.oldValues.get(key), v)) continue;
                    this.copyToOld();
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    Object v = value.getter().apply(te);
                    value.getKey().getType().serialize(buf, v);
                }
            }

            @Override
            public void readBuf(PacketBuffer buf) {
                for (ValueHolder<?, ?> value : te.getValueMap().values()) {
                    value.getKey().getType().deserialize(buf, value, te);
                }
            }
        };
    }

    public static IContainerDataListener string(final ResourceLocation id, final Supplier<String> getter, final Consumer<String> setter) {
        return new IContainerDataListener(){
            private String oldString = null;

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public boolean isDirtyAndClear() {
                String newValue = (String)getter.get();
                if (!Objects.equals(newValue, this.oldString)) {
                    this.oldString = newValue;
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                buf.func_180714_a((String)getter.get());
            }

            @Override
            public void readBuf(PacketBuffer buf) {
                setter.accept(buf.func_150789_c(Short.MAX_VALUE));
            }
        };
    }

    public static IContainerDataListener flt(final ResourceLocation id, final Supplier<Float> getter, final Consumer<Float> setter) {
        return new IContainerDataListener(){
            private Float oldFloat = null;

            @Override
            public ResourceLocation getId() {
                return id;
            }

            @Override
            public boolean isDirtyAndClear() {
                Float newValue = (Float)getter.get();
                if (!Objects.equals(newValue, this.oldFloat)) {
                    this.oldFloat = newValue;
                    return true;
                }
                return false;
            }

            @Override
            public void toBytes(PacketBuffer buf) {
                buf.writeFloat(((Float)getter.get()).floatValue());
            }

            @Override
            public void readBuf(PacketBuffer buf) {
                setter.accept(Float.valueOf(buf.readFloat()));
            }
        };
    }

    public static IntReferenceHolder integer(final Supplier<Integer> getter, final Consumer<Integer> setter) {
        return new IntReferenceHolder(){

            public int func_221495_b() {
                return (Integer)getter.get();
            }

            public void func_221494_a(int v) {
                setter.accept(v);
            }
        };
    }

    public static IntReferenceHolder shortint(final Supplier<Short> getter, final Consumer<Short> setter) {
        return new IntReferenceHolder(){

            public int func_221495_b() {
                return ((Short)getter.get()).shortValue();
            }

            public void func_221494_a(int v) {
                setter.accept((short)v);
            }
        };
    }

    public static <T extends Enum<T>> IntReferenceHolder enumeration(final Supplier<T> getter, final Consumer<T> setter, T[] values) {
        return new IntReferenceHolder((Enum[])values){
            final /* synthetic */ Enum[] val$values;
            {
                this.val$values = enumArray;
            }

            public int func_221495_b() {
                return ((Enum)getter.get()).ordinal();
            }

            public void func_221494_a(int v) {
                setter.accept(this.val$values[v]);
            }
        };
    }

    public static IntReferenceHolder bool(final Supplier<Boolean> getter, final Consumer<Boolean> setter) {
        return new IntReferenceHolder(){

            public int func_221495_b() {
                return (Boolean)getter.get() != false ? 1 : 0;
            }

            public void func_221494_a(int v) {
                setter.accept(v != 0);
            }
        };
    }
}

