/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.lib.varia.TriConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class NBTTools {
    public static <T> T getInfoNBT(ItemStack stack, BiFunction<CompoundNBT, String, T> getter, String name, T def) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return def;
        }
        CompoundNBT info = tag.func_74775_l("BlockEntityTag").func_74775_l("Info");
        if (info.func_74764_b(name)) {
            return getter.apply(info, name);
        }
        return def;
    }

    public static <T> T getBlockEntityNBT(ItemStack stack, BiFunction<CompoundNBT, String, T> getter, String name, T def) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return def;
        }
        CompoundNBT info = tag.func_74775_l("BlockEntityTag");
        if (info.func_74764_b(name)) {
            return getter.apply(info, name);
        }
        return def;
    }

    public static <T> void setInfoNBT(ItemStack stack, TriConsumer<CompoundNBT, String, T> setter, String name, T value) {
        CompoundNBT entityTag = stack.func_190925_c("BlockEntityTag");
        CompoundNBT info = entityTag.func_74775_l("Info");
        setter.accept(info, name, value);
        entityTag.func_218657_a("Info", (INBT)info);
    }

    public static boolean hasInfoNBT(ItemStack stack, String name) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return false;
        }
        CompoundNBT info = tag.func_74775_l("BlockEntityTag").func_74775_l("Info");
        return info.func_74764_b(name);
    }

    public static int getInt(ItemStack stack, String name, int def) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return def;
        }
        if (tag.func_74764_b(name)) {
            return tag.func_74762_e(name);
        }
        return def;
    }

    public static float getFloat(ItemStack stack, String name, float def) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return def;
        }
        if (tag.func_74764_b(name)) {
            return tag.func_74760_g(name);
        }
        return def;
    }

    public static String getString(ItemStack stack, String name, String def) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return def;
        }
        if (tag.func_74764_b(name)) {
            return tag.func_74779_i(name);
        }
        return def;
    }

    @Nonnull
    public static Optional<CompoundNBT> getTag(@Nonnull ItemStack stack) {
        return Optional.ofNullable(stack.func_77978_p());
    }

    @Nonnull
    public static <R> R mapTag(@Nonnull ItemStack stack, Function<CompoundNBT, R> mapping, @Nonnull R def) {
        if (stack.func_77942_o()) {
            return mapping.apply(stack.func_77978_p());
        }
        return def;
    }

    @Nonnull
    public static Function<ItemStack, String> intGetter(String tag, Integer def) {
        return stack -> Integer.toString(NBTTools.mapTag(stack, nbt -> nbt.func_74762_e(tag), def));
    }

    @Nonnull
    public static Function<ItemStack, String> strGetter(String tag, String def) {
        return stack -> NBTTools.mapTag(stack, nbt -> nbt.func_74779_i(tag), def);
    }

    @Nonnull
    public static Stream<INBT> getListStream(CompoundNBT compound, String tag) {
        ListNBT list = compound.func_150295_c("Items", 10);
        return StreamSupport.stream(list.spliterator(), false);
    }
}

