/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.tileentity;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.information.CapabilityPowerInformation;
import mcjty.lib.api.infusable.CapabilityInfusable;
import mcjty.lib.api.module.CapabilityModuleSupport;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.blockcommands.IRunnable;
import mcjty.lib.blockcommands.IRunnableWithList;
import mcjty.lib.blockcommands.IRunnableWithListResult;
import mcjty.lib.blockcommands.IRunnableWithResult;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.tileentity.AnnotationHolder;
import mcjty.lib.tileentity.AnnotationTools;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.ValueHolder;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GenericTileEntity
extends TileEntity {
    public static final Key<Integer> VALUE_RSMODE = new Key<Integer>("rsmode", Type.INTEGER);
    private String ownerName = "";
    private UUID ownerUUID = null;
    private int securityChannel = -1;
    protected RedstoneMode rsMode = RedstoneMode.REDSTONE_IGNORED;
    protected int powerLevel = 0;
    private BiFunction<Capability, Direction, LazyOptional> capSetup = (cap, dir) -> {
        List<Pair<Field, Cap>> list = this.getAnnotationHolder().capabilityList;
        this.capSetup = this.generateCapTests(list, 0);
        return this.capSetup.apply((Capability)cap, (Direction)dir);
    };
    @ServerCommand
    public static final Command<?> COMMAND_SYNC_BINDING = Command.create("generic.syncBinding", (te, playerEntity, params) -> te.syncBinding(params));
    @ServerCommand
    public static final Command<?> CMD_RSMODE = Command.create("mcjtylib.setRsMode", (te, playerEntity, params) -> te.setRSMode(RedstoneMode.values()[params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]));

    public GenericTileEntity(TileEntityType<?> type) {
        super(type);
        this.getAnnotationHolder();
    }

    private BiFunction<Capability, Direction, LazyOptional> generateCapTests(List<Pair<Field, Cap>> caps, int index) {
        if (index >= caps.size()) {
            return (x$0, x$1) -> super.getCapability(x$0, x$1);
        }
        try {
            Cap annotation = (Cap)caps.get(index).getRight();
            Object instance = FieldUtils.readField((Field)((Field)caps.get(index).getLeft()), (Object)((Object)this), (boolean)true);
            LazyOptional lazy = instance instanceof LazyOptional ? (LazyOptional)instance : (annotation.type() == CapType.ITEMS_AUTOMATION ? LazyOptional.of(() -> new AutomationFilterItemHander((GenericItemHandler)instance)) : LazyOptional.of(() -> instance));
            BiFunction<Capability, Direction, LazyOptional> tail = this.generateCapTests(caps, index + 1);
            switch (annotation.type()) {
                case ITEMS: {
                    return (cap, dir) -> {
                        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case ITEMS_AUTOMATION: {
                    return (cap, dir) -> {
                        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case CONTAINER: {
                    return (cap, dir) -> {
                        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case ENERGY: {
                    return (cap, dir) -> {
                        if (cap == CapabilityEnergy.ENERGY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case INFUSABLE: {
                    return (cap, dir) -> {
                        if (cap == CapabilityInfusable.INFUSABLE_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case MODULE: {
                    return (cap, dir) -> {
                        if (cap == CapabilityModuleSupport.MODULE_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case POWER_INFO: {
                    return (cap, dir) -> {
                        if (cap == CapabilityPowerInformation.POWER_INFORMATION_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
                case FLUIDS: {
                    return (cap, dir) -> {
                        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                            return lazy;
                        }
                        return (LazyOptional)tail.apply((Capability)cap, (Direction)dir);
                    };
                }
            }
            throw new RuntimeException("Unknown cap type");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return this.capSetup.apply(cap, side);
    }

    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public void markDirtyQuick() {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    public Map<String, ValueHolder<?, ?>> getValueMap() {
        AnnotationHolder holder = this.getAnnotationHolder();
        return holder.valueMap;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void onReplaced(World world, BlockPos pos, BlockState state, BlockState newstate) {
    }

    public void onPartAdded(PartSlot slot, BlockState state, TileEntity multipartTile) {
    }

    public ActionResultType onBlockActivated(BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return ActionResultType.PASS;
    }

    protected boolean needsRedstoneMode() {
        return false;
    }

    public void checkRedstone(World world, BlockPos pos) {
        int powered = world.func_175687_A(pos);
        this.setPowerInput(powered);
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerLevel = powered;
            this.func_70296_d();
        }
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public RedstoneMode getRSMode() {
        return this.rsMode;
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        this.rsMode = redstoneMode;
        this.markDirtyClient();
    }

    public void setRSModeInt(int i) {
        this.setRSMode(RedstoneMode.values()[i]);
    }

    public int getRSModeInt() {
        return this.rsMode.ordinal();
    }

    public boolean isMachineEnabled() {
        if (this.rsMode != RedstoneMode.REDSTONE_IGNORED) {
            boolean rs;
            boolean bl = rs = this.powerLevel > 0;
            if (this.rsMode == RedstoneMode.REDSTONE_OFFREQUIRED && rs) {
                return false;
            }
            if (this.rsMode == RedstoneMode.REDSTONE_ONREQUIRED && !rs) {
                return false;
            }
        }
        return true;
    }

    public void onSlotChanged(int index, ItemStack stack) {
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        this.loadClientDataFromNBT(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.saveClientDataToNBT(nbtTag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.loadClientDataFromNBT(packet.func_148857_g());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canPlayerAccess(PlayerEntity player) {
        if (this.func_145837_r()) return false;
        Vector3d vector3d = new Vector3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        if (!(player.func_195048_a(vector3d.func_72441_c(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.saveClientDataToNBT(updateTag);
        return updateTag;
    }

    public void saveClientDataToNBT(CompoundNBT tagCompound) {
    }

    public void loadClientDataFromNBT(CompoundNBT tagCompound) {
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.load(tagCompound);
    }

    public void load(CompoundNBT tagCompound) {
        this.loadCaps(tagCompound);
        this.loadInfo(tagCompound);
    }

    protected void loadCaps(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> h.setInfused(infoTag.func_74762_e("infused")));
        }
        this.loadItemHandlerCap(tagCompound);
        this.loadEnergyCap(tagCompound);
    }

    protected void loadItemHandlerCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> h.deserializeNBT((INBT)tagCompound.func_150295_c("Items", 10)));
    }

    protected void loadEnergyCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> {
            if (tagCompound.func_74764_b("Energy")) {
                h.deserializeNBT(tagCompound.func_74781_a("Energy"));
            }
        });
    }

    protected void loadInfo(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            CompoundNBT infoTag = tagCompound.func_74775_l("Info");
            if (infoTag.func_74764_b("powered")) {
                this.powerLevel = infoTag.func_74771_c("powered");
            }
            if (this.needsRedstoneMode() && infoTag.func_74764_b("rsMode")) {
                byte m = infoTag.func_74771_c("rsMode");
                this.rsMode = RedstoneMode.values()[m];
            }
            if (infoTag.func_74764_b("owner")) {
                this.ownerName = infoTag.func_74779_i("owner");
            }
            if (infoTag.func_186855_b("ownerId")) {
                this.ownerUUID = infoTag.func_186857_a("ownerId");
            }
            if (infoTag.func_74764_b("secChannel")) {
                this.securityChannel = infoTag.func_74762_e("secChannel");
            }
        }
    }

    protected CompoundNBT getOrCreateInfo(CompoundNBT tagCompound) {
        if (tagCompound.func_74764_b("Info")) {
            return tagCompound.func_74775_l("Info");
        }
        CompoundNBT data = new CompoundNBT();
        tagCompound.func_218657_a("Info", (INBT)data);
        return data;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.saveAdditional(tagCompound);
        return tagCompound;
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        this.saveCaps(tagCompound);
        this.saveInfo(tagCompound);
    }

    protected void saveCaps(CompoundNBT tagCompound) {
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        this.getCapability(CapabilityInfusable.INFUSABLE_CAPABILITY).ifPresent(h -> infoTag.func_74768_a("infused", h.getInfused()));
        this.saveItemHandlerCap(tagCompound);
        this.saveEnergyCap(tagCompound);
    }

    protected void saveItemHandlerCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.func_218657_a("Items", h.serializeNBT()));
    }

    protected void saveEnergyCap(CompoundNBT tagCompound) {
        this.getCapability(CapabilityEnergy.ENERGY).filter(h -> h instanceof INBTSerializable).map(h -> (INBTSerializable)h).ifPresent(h -> tagCompound.func_218657_a("Energy", h.serializeNBT()));
    }

    protected void saveInfo(CompoundNBT tagCompound) {
        CompoundNBT infoTag = this.getOrCreateInfo(tagCompound);
        infoTag.func_74774_a("powered", (byte)this.powerLevel);
        if (this.needsRedstoneMode()) {
            infoTag.func_74774_a("rsMode", (byte)this.rsMode.ordinal());
        }
        infoTag.func_74778_a("owner", this.ownerName);
        if (this.ownerUUID != null) {
            infoTag.func_186854_a("ownerId", this.ownerUUID);
        }
        if (this.securityChannel != -1) {
            infoTag.func_74768_a("secChannel", this.securityChannel);
        }
    }

    public boolean setOwner(PlayerEntity player) {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return false;
        }
        if (this.ownerUUID != null) {
            return false;
        }
        this.ownerUUID = player.func_146103_bH().getId();
        this.ownerName = player.func_200200_C_().getString();
        this.markDirtyClient();
        return true;
    }

    public void clearOwner() {
        if (!((Boolean)GeneralConfig.manageOwnership.get()).booleanValue()) {
            return;
        }
        this.ownerUUID = null;
        this.ownerName = "";
        this.securityChannel = -1;
        this.markDirtyClient();
    }

    public void setSecurityChannel(int id) {
        this.securityChannel = id;
        this.markDirtyClient();
    }

    public int getSecurityChannel() {
        return this.securityChannel;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean checkAccess(PlayerEntity player) {
        return false;
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return -1;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockReader world, BlockPos pos, BlockState metadata, int fortune) {
    }

    public void rotateBlock(Rotation axis) {
    }

    public boolean wrenchUse(World world, BlockPos pos, Direction side, PlayerEntity player) {
        return false;
    }

    private <T extends GenericTileEntity, V> BiConsumer<T, V> findSetter(Key<V> key) {
        for (Map.Entry<String, ValueHolder<?, ?>> entry : this.getValueMap().entrySet()) {
            ValueHolder<?, ?> value = entry.getValue();
            if (!key.getName().equals(value.getKey().getName())) continue;
            return value.setter();
        }
        return null;
    }

    public RegistryKey<World> getDimension() {
        return this.field_145850_b.func_234923_W_();
    }

    public void requestDataFromServer(SimpleChannel channel, ICommand command, @Nonnull TypedMap params) {
        channel.sendToServer((Object)new PacketRequestDataFromServer(this.getDimension(), this.field_174879_c, command.getName(), params, false));
    }

    public boolean executeClientCommand(String command, PlayerEntity player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnable<?> clientCommand = holder.clientCommands.get(command);
        if (clientCommand != null) {
            clientCommand.run(this, player, params);
            return true;
        }
        return false;
    }

    public IRunnable<?> findServerCommand(String command) {
        AnnotationHolder holder = this.getAnnotationHolder();
        return holder.serverCommands.get(command);
    }

    public boolean executeServerCommand(String command, PlayerEntity player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnable<?> serverCommand = holder.serverCommands.get(command);
        if (serverCommand != null) {
            serverCommand.run(this, player, params);
            return true;
        }
        return false;
    }

    public <T> List<T> executeServerCommandList(String command, PlayerEntity player, @Nonnull TypedMap params, @Nonnull Class<T> type) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithListResult<?, ?> cmd = holder.serverCommandsWithListResult.get(command);
        if (cmd != null) {
            return cmd.run(this, player, params);
        }
        return Collections.emptyList();
    }

    public <T> boolean handleListFromServer(String command, PlayerEntity player, @Nonnull TypedMap params, @Nonnull List<T> list) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithList<?, ?> cmd = holder.clientCommandsWithList.get(command);
        if (cmd != null) {
            cmd.run(this, player, params, list);
            return true;
        }
        return false;
    }

    @Nullable
    public TypedMap executeServerCommandWR(String command, PlayerEntity player, @Nonnull TypedMap params) {
        AnnotationHolder holder = this.getAnnotationHolder();
        IRunnableWithResult<?> serverCommand = holder.serverCommandsWithResult.get(command);
        if (serverCommand != null) {
            return serverCommand.run(this, player, params);
        }
        return null;
    }

    private AnnotationHolder getAnnotationHolder() {
        AnnotationHolder holder = AnnotationHolder.annotations.get(this.func_200662_C());
        if (holder == null) {
            holder = AnnotationTools.createAnnotationHolder(this.func_200662_C(), ((Object)((Object)this)).getClass());
        }
        return holder;
    }

    private <T> void syncBindingHelper(TypedMap params, Key<T> bkey) {
        T o = params.get(bkey);
        this.findSetter(bkey).accept(this, (GenericTileEntity)((Object)o));
    }

    private void syncBinding(TypedMap params) {
        for (Key<?> key : params.getKeys()) {
            this.syncBindingHelper(params, key);
        }
        this.markDirtyClient();
    }
}

