/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketServerCommandTyped {
    protected BlockPos pos;
    protected RegistryKey<World> dimensionId;
    protected String command;
    protected TypedMap params;

    public PacketServerCommandTyped(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dimensionId = buf.readBoolean() ? LevelTools.getId(buf.func_192575_l()) : null;
    }

    public PacketServerCommandTyped(BlockPos pos, RegistryKey<World> dimensionId, String command, TypedMap params) {
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dimensionId = dimensionId;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        if (this.dimensionId != null) {
            buf.writeBoolean(true);
            buf.func_192572_a(this.dimensionId.func_240901_a_());
        } else {
            buf.writeBoolean(false);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayerEntity playerEntity = ctx.getSender();
            Object world = this.dimensionId == null ? playerEntity.func_130014_f_() : LevelTools.getLevel(playerEntity.field_70170_p, this.dimensionId);
            if (world == null) {
                return;
            }
            if (world.func_175667_e(this.pos)) {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof GenericTileEntity && ((GenericTileEntity)te).executeServerCommand(this.command, (PlayerEntity)playerEntity, this.params)) {
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

