/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public class NetworkTools {
    public static FluidStack readFluidStack(ByteBuf dataIn) {
        PacketBuffer buf = new PacketBuffer(dataIn);
        CompoundNBT nbt = buf.func_150793_b();
        return FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
    }

    public static void writeFluidStack(ByteBuf dataOut, FluidStack fluidStack) {
        PacketBuffer buf = new PacketBuffer(dataOut);
        CompoundNBT nbt = new CompoundNBT();
        fluidStack.writeToNBT(nbt);
        try {
            buf.func_150786_a(nbt);
        }
        catch (RuntimeException e) {
            Logging.logError("Error writing fluid stack", e);
        }
    }

    public static String readStringUTF8(PacketBuffer dataIn) {
        if (!dataIn.readBoolean()) {
            return null;
        }
        return dataIn.func_150789_c(Short.MAX_VALUE);
    }

    public static void writeStringUTF8(PacketBuffer dataOut, String str) {
        if (str == null) {
            dataOut.writeBoolean(false);
            return;
        }
        dataOut.writeBoolean(true);
        dataOut.func_180714_a(str);
    }

    public static void writeStringList(PacketBuffer dataOut, @Nonnull List<String> list) {
        dataOut.writeInt(list.size());
        list.forEach(s -> NetworkTools.writeStringUTF8(dataOut, s));
    }

    @Nonnull
    public static List<String> readStringList(PacketBuffer dataIn) {
        int size = dataIn.readInt();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(NetworkTools.readStringUTF8(dataIn));
        }
        return list;
    }

    public static ItemStack readItemStack(PacketBuffer buf) {
        CompoundNBT nbt = buf.func_150793_b();
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        stack.func_190920_e(buf.readInt());
        return stack;
    }

    public static void writeItemStack(PacketBuffer buf, ItemStack itemStack) {
        CompoundNBT nbt = new CompoundNBT();
        itemStack.func_77955_b(nbt);
        try {
            buf.func_150786_a(nbt);
            buf.writeInt(itemStack.func_190916_E());
        }
        catch (Exception e) {
            Logging.logError("Error", e);
        }
    }

    public static <T extends Enum<T>> void writeEnum(ByteBuf buf, T value, T nullValue) {
        if (value == null) {
            buf.writeInt(nullValue.ordinal());
        } else {
            buf.writeInt(value.ordinal());
        }
    }

    public static <T extends Enum<T>> T readEnum(ByteBuf buf, T[] values) {
        return values[buf.readInt()];
    }

    public static <T extends Enum<T>> void writeEnumCollection(ByteBuf buf, Collection<T> collection) {
        buf.writeInt(collection.size());
        for (Enum type : collection) {
            buf.writeInt(type.ordinal());
        }
    }

    public static <T extends Enum<T>> void readEnumCollection(ByteBuf buf, Collection<T> collection, T[] values) {
        collection.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            collection.add(values[buf.readInt()]);
        }
    }

    @Nonnull
    public static List<ItemStack> readItemStackList(PacketBuffer buf) {
        int size = buf.readInt();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            outputs.add(buf.func_150791_c());
        }
        return outputs;
    }

    public static void writeItemStackList(PacketBuffer buf, @Nonnull List<ItemStack> outputs) {
        buf.writeInt(outputs.size());
        for (ItemStack output : outputs) {
            buf.func_150788_a(output);
        }
    }

    public static void writeBlockPosList(PacketBuffer dataOut, @Nonnull List<BlockPos> list) {
        dataOut.writeInt(list.size());
        list.forEach(arg_0 -> ((PacketBuffer)dataOut).func_179255_a(arg_0));
    }

    @Nonnull
    public static List<BlockPos> readBlockPosList(PacketBuffer dataIn) {
        int size = dataIn.readInt();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            list.add(dataIn.func_179259_c());
        }
        return list;
    }
}

