/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class HudRenderHelper {
    public static void renderHudItems(MatrixStack matrixStack, IRenderTypeBuffer buffer, List<Pair<ItemStack, String>> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        matrixStack.func_227860_a_();
        if (hudPlacement == HudPlacement.HUD_FRONT) {
            matrixStack.func_227861_a_((double)((float)x + 0.5f), (double)((float)y + 0.75f), (double)((float)z + 0.5f));
        } else if (hudPlacement == HudPlacement.HUD_CENTER) {
            matrixStack.func_227861_a_((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        } else {
            matrixStack.func_227861_a_((double)((float)x + 0.5f), (double)((float)y + 1.75f), (double)((float)z + 0.5f));
        }
        Quaternion quaternion = Minecraft.func_71410_x().func_175598_ae().func_229098_b_();
        switch (hudOrientation) {
            case HUD_SOUTH: {
                matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -HudRenderHelper.getHudAngle(orientation), true));
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                matrixStack.func_227863_a_(quaternion);
                break;
            }
            case HUD_TOPLAYER: {
                matrixStack.func_227863_a_(quaternion);
            }
        }
        if (hudPlacement == HudPlacement.HUD_FRONT || hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            matrixStack.func_227861_a_(0.0, -0.25, 0.4624999761581421);
        } else if (hudPlacement != HudPlacement.HUD_CENTER) {
            matrixStack.func_227861_a_(0.0, -0.25, -0.03749999403953552);
        }
        HudRenderHelper.renderText(matrixStack, buffer, Minecraft.func_71410_x().field_71466_p, messages, 11, scale);
        matrixStack.func_227865_b_();
    }

    public static void renderHud(MatrixStack stack, IRenderTypeBuffer buffer, List<String> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        HudRenderHelper.renderHudItems(stack, buffer, messages.stream().map(s -> Pair.of((Object)ItemStack.field_190927_a, (Object)s)).collect(Collectors.toList()), hudPlacement, hudOrientation, orientation, x, y, z, scale);
    }

    private static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            switch (orientation) {
                case NORTH: {
                    f3 = 180.0f;
                    break;
                }
                case WEST: {
                    f3 = 90.0f;
                    break;
                }
                case EAST: {
                    f3 = -90.0f;
                    break;
                }
                default: {
                    f3 = 0.0f;
                }
            }
        }
        return f3;
    }

    private static void renderText(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontrenderer, List<Pair<ItemStack, String>> messages, int lines, float scale) {
        matrixStack.func_227861_a_(-0.5, 0.5, (double)0.07f);
        float f3 = 0.0075f;
        matrixStack.func_227862_a_(f3 * scale, -f3 * scale, f3);
        HudRenderHelper.renderLog(matrixStack, buffer, fontrenderer, messages, lines);
    }

    private static void renderLog(MatrixStack matrixStack, IRenderTypeBuffer buffer, FontRenderer fontrenderer, List<Pair<ItemStack, String>> messages, int lines) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (Pair<ItemStack, String> pair : messages) {
            ItemStack stack = (ItemStack)pair.getLeft();
            String s = (String)pair.getRight();
            if (i >= logsize - lines && currenty + height <= 124) {
                String prefix = "";
                if (!stack.func_190926_b()) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(14.0, (double)((float)currenty + 4.0f), 0.0);
                    matrixStack.func_227862_a_(10.0f, -10.0f, 16.0f);
                    ItemRenderer itemRender = Minecraft.func_71410_x().func_175599_af();
                    IBakedModel ibakedmodel = itemRender.func_184393_a(stack, (World)Minecraft.func_71410_x().field_71441_e, null);
                    itemRender.func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, buffer, 0xF000F0, OverlayTexture.field_229196_a_, ibakedmodel);
                    prefix = "    ";
                    matrixStack.func_227865_b_();
                }
                fontrenderer.func_228079_a_(fontrenderer.func_238412_a_(prefix + s, 115), 7.0f, (float)currenty, 0xFFFFFF, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }
}

