/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.util;

public final class Formatting {
    public static String timeInSeconds(int value, TimeUnit valueUnit) {
        return String.format("%02ds", valueUnit.toSeconds(value));
    }

    public static String timeInMinutes(int value, TimeUnit valueUnit) {
        return String.format("%02ds", valueUnit.toMinutes(value));
    }

    public static String timeInMinutesAndOrSeconds(int value, TimeUnit valueUnit) {
        int minutes = valueUnit.toMinutes(value);
        int seconds = valueUnit.toSeconds(value) - minutes * 60;
        if (minutes > 0) {
            return String.format("%02dm %02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    public static enum TimeUnit {
        TICKS(1),
        SECONDS(20),
        MINUTES(1200);

        private final int ticks;

        private TimeUnit(int ticks) {
            this.ticks = ticks;
        }

        public int toTicks(int value) {
            return value * this.ticks;
        }

        public int toSeconds(int value) {
            return this.toTicks(value) / 20;
        }

        public int toMinutes(int value) {
            return this.toTicks(value) / 1200;
        }
    }
}

