/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.styles;

import com.google.common.collect.ImmutableMap;
import io.github.drmanganese.topaddons.addons.forge.ForgeAddon;
import io.github.drmanganese.topaddons.config.Config;
import java.awt.Color;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.ILayoutStyle;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class Styles {
    public static final ILayoutStyle CENTERED = new LayoutStyle().alignment(ElementAlignment.ALIGN_CENTER);
    private static final ImmutableMap<DyeColor, Colors> DYE_COLORS = ImmutableMap.copyOf(Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), x$0 -> new Colors((DyeColor)x$0))));
    private static final IProgressStyle MACHINE_PROGRESS_STYLE = new ProgressStyle().suffix("%");

    public static IProgressStyle machineProgress(PlayerEntity player) {
        return Styles.machineProgress(player, "topaddons:progress");
    }

    public static IProgressStyle machineProgress(PlayerEntity player, String prefixWord) {
        int borderColor = Config.getSyncedColor(player, ForgeAddon.machineProgressBorderColor);
        int backgroundColor = Config.getSyncedColor(player, ForgeAddon.machineProgressBackgroundColor);
        return MACHINE_PROGRESS_STYLE.copy().borderColor(borderColor).backgroundColor(backgroundColor).prefix((ITextComponent)new TranslationTextComponent(prefixWord).func_240702_b_(": "));
    }

    public static class Colors {
        public final DyeColor dye;
        public final int dyeColor;
        public final int darkerColor;
        public final int semiTransparentColor;

        private Colors(DyeColor dyeColor) {
            this.dye = dyeColor;
            this.dyeColor = dyeColor.getColorValue() | 0xFF000000;
            this.darkerColor = new Color(this.dyeColor).darker().hashCode();
            this.semiTransparentColor = this.darkerColor & 0x33FFFFFF;
        }

        public static Colors fromDye(DyeColor dyeColor) {
            return (Colors)DYE_COLORS.get((Object)dyeColor);
        }
    }
}

