/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.network;

import io.github.drmanganese.topaddons.TopAddons;
import io.github.drmanganese.topaddons.network.ClientConfigSyncMessage;
import io.github.drmanganese.topaddons.network.ElementSyncMessage;
import io.github.drmanganese.topaddons.network.ResetColorMapsMessage;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel INSTANCE;

    public static void init() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("topaddons", "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(0, ElementSyncMessage.class, ElementSyncMessage::encode, ElementSyncMessage::decode, ElementSyncMessage::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        INSTANCE.registerMessage(1, ClientConfigSyncMessage.class, ClientConfigSyncMessage::encode, ClientConfigSyncMessage::decode, ClientConfigSyncMessage::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        INSTANCE.registerMessage(2, ResetColorMapsMessage.class, PacketHandler::dummyEncoder, b -> new ResetColorMapsMessage(), ResetColorMapsMessage::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendElementSync(Map<String, Integer> elementIdMap) {
        TopAddons.LOGGER.debug("Player {}({}) syncing element ids to server", (Object)Minecraft.func_71410_x().field_71439_g.func_145748_c_(), (Object)Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        INSTANCE.sendToServer((Object)new ElementSyncMessage(elementIdMap));
    }

    public static void sendClientCfg(Map<String, String> syncMap) {
        TopAddons.LOGGER.debug("Player {}({}) syncing config to server", (Object)Minecraft.func_71410_x().field_71439_g.func_145748_c_(), (Object)Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        INSTANCE.sendToServer((Object)new ClientConfigSyncMessage(syncMap));
    }

    public static void sendResetColorsMapsMessage(ServerPlayerEntity targetPlayer) {
        TopAddons.LOGGER.debug("Asking {}({}) to reset fluid color maps", (Object)Minecraft.func_71410_x().field_71439_g.func_145748_c_(), (Object)Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> targetPlayer), (Object)new ResetColorMapsMessage());
    }

    private static <MSG> void dummyEncoder(MSG msg, PacketBuffer buf) {
    }
}

