/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.elements.bloodmagic;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.drmanganese.topaddons.addons.forge.ForgeAddon;
import io.github.drmanganese.topaddons.util.ElementHelper;
import mcjty.theoneprobe.api.IElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import wayoftime.bloodmagic.common.item.IBloodOrb;

public class BloodAltarProgressElement
implements IElement {
    private final int progress;
    private final int maxProgress;
    private final ItemStack inputStack;
    private final ItemStack outputStack;
    private final float consumption;
    private int id;

    public BloodAltarProgressElement(int id, int progress, int maxProgress, ItemStack inputStack, ItemStack outputStack, float consumption) {
        this.progress = progress;
        this.maxProgress = maxProgress;
        this.inputStack = inputStack;
        this.outputStack = outputStack;
        this.consumption = consumption;
        this.id = id;
    }

    public BloodAltarProgressElement(PacketBuffer packetBuffer) {
        this.progress = packetBuffer.readInt();
        this.maxProgress = packetBuffer.readInt();
        this.inputStack = packetBuffer.func_150791_c();
        this.outputStack = packetBuffer.func_150791_c();
        this.consumption = packetBuffer.readFloat();
    }

    public void render(MatrixStack matrixStack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_175599_af().func_180450_b(this.inputStack, x, y);
        mc.func_175599_af().func_180450_b(this.outputStack, x + 84, y);
        ElementHelper.drawBox(matrixStack, x + 18, y + 3, 64, 10, ForgeAddon.machineProgressBackgroundColor.getInt(), 1, ForgeAddon.machineProgressBorderColor.getInt());
        RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        mc.func_110434_K().func_110577_a(new ResourceLocation("topaddons:textures/elements/bm_altar.png"));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_225582_a_((double)(x + 19), (double)(y + 4), 0.0).func_225583_a_(1.0f - (float)this.progress / (float)this.maxProgress, 0.0f).func_181675_d();
        buf.func_225582_a_((double)(x + 19), (double)(y + 12), 0.0).func_225583_a_(1.0f - (float)this.progress / (float)this.maxProgress, 1.0f).func_181675_d();
        buf.func_225582_a_((double)((float)(x + 19) + 62.0f * (float)this.progress / (float)this.maxProgress), (double)(y + 12), 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buf.func_225582_a_((double)((float)(x + 19) + 62.0f * (float)this.progress / (float)this.maxProgress), (double)(y + 4), 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
        String barText = this.progress + "/" + this.maxProgress + " LP";
        ElementHelper.drawSmallText(matrixStack, mc, x + 50 - mc.field_71466_p.func_78256_a(barText) / 4, y + 6, barText, -1);
        String belowText = this.inputStack.func_77973_b() instanceof IBloodOrb ? new TranslationTextComponent("topaddons.bloodmagic:filling").getString() : new TranslationTextComponent("topaddons.bloodmagic:consumption").getString() + ": " + this.consumption + " LP";
        ElementHelper.drawSmallText(matrixStack, mc, x + 50 - mc.field_71466_p.func_78256_a(belowText) / 4, y + 14, belowText, -1);
    }

    public int getWidth() {
        return 100;
    }

    public int getHeight() {
        return 18;
    }

    public void toBytes(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.progress);
        packetBuffer.writeInt(this.maxProgress);
        packetBuffer.func_150788_a(this.inputStack);
        packetBuffer.func_150788_a(this.outputStack);
        packetBuffer.writeFloat(this.consumption);
    }

    public int getID() {
        return this.id;
    }
}

