/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.config;

import io.github.drmanganese.topaddons.AddonRegistry;
import io.github.drmanganese.topaddons.TopAddons;
import io.github.drmanganese.topaddons.api.IAddonConfig;
import io.github.drmanganese.topaddons.capabilities.ClientCfgCapability;
import io.github.drmanganese.topaddons.config.ColorValue;
import io.github.drmanganese.topaddons.network.PacketHandler;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="topaddons", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec CLIENT_CONFIG;
    private static final ForgeConfigSpec.Builder COMMON_BUILDER;
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER;

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading modConfigEvent) {
        if (modConfigEvent.getConfig().getType() == ModConfig.Type.CLIENT && Minecraft.func_71410_x().field_71441_e != null) {
            PacketHandler.sendClientCfg(Config.collectClientConfigValues());
        }
    }

    public static Map<String, String> collectClientConfigValues() {
        return AddonRegistry.getAddonConfigStream().map(IAddonConfig::getClientConfigValuesToSync).flatMap(Collection::stream).collect(Collectors.toMap(Config::fullPathFromConfigValue, Config::configValueToString));
    }

    public static boolean getSyncedBoolean(PlayerEntity player, ForgeConfigSpec.BooleanValue configValue) {
        return (Boolean)Config.getSynced(player, configValue, ClientCfgCapability::getBool);
    }

    public static String getSyncedString(PlayerEntity player, ForgeConfigSpec.ConfigValue<String> configValue) {
        return Config.getSynced(player, configValue, ClientCfgCapability::getString);
    }

    public static int getSyncedColor(PlayerEntity player, ColorValue colorValue) {
        return ColorValue.decodeString(Config.getSyncedString(player, colorValue.configValue));
    }

    public static <E extends Enum<E>> Enum<E> getSyncedEnum(PlayerEntity player, ForgeConfigSpec.EnumValue<E> configValue) {
        BiFunction clientCfgGetter = (cap, key) -> cap.getEnum((String)key, ((Enum)configValue.get()).getDeclaringClass());
        return (Enum)Config.getSynced(player, configValue, clientCfgGetter);
    }

    private static <T> T getSynced(PlayerEntity player, ForgeConfigSpec.ConfigValue<T> configValue, BiFunction<ClientCfgCapability, String, Optional<T>> clientCfgGetter) {
        String path = Config.fullPathFromConfigValue(configValue);
        Optional<Object> syncedValue = player.getCapability(TopAddons.CLIENT_CFG_CAP).map(cap -> (Optional)clientCfgGetter.apply((ClientCfgCapability)cap, path)).orElse(Optional.empty());
        return (T)syncedValue.orElse(configValue.get());
    }

    private static String fullPathFromConfigValue(ForgeConfigSpec.ConfigValue<?> configValue) {
        return String.join((CharSequence)".", configValue.getPath());
    }

    private static String configValueToString(ForgeConfigSpec.ConfigValue<?> configValue) {
        return configValue.get().toString();
    }

    static {
        COMMON_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        AddonRegistry.getAddonConfigStream().forEachOrdered(a -> a.buildConfig(COMMON_BUILDER, ModConfig.Type.COMMON));
        COMMON_CONFIG = COMMON_BUILDER.build();
        AddonRegistry.getAddonConfigStream().forEachOrdered(a -> a.buildConfig(CLIENT_BUILDER, ModConfig.Type.CLIENT));
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }
}

