/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;

public class FluidColorExtraction {
    private static final Fluid DEFAULT = Fluids.field_204546_a;
    private static final AtlasTexture TEXTURE = Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_);

    static int extractTopLeftColorFromTexture(TextureAtlasSprite sprite) {
        int abgr = sprite.getPixelRGBA(0, 0, 0);
        return 0xFF000000 | FluidColorExtraction.red(abgr) << 16 | FluidColorExtraction.green(abgr) << 8 | FluidColorExtraction.blue(abgr);
    }

    static int extractAvgColorFromTexture(TextureAtlasSprite sprite) {
        int width = sprite.func_94211_a();
        int n = width * width;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < width; ++y) {
                int abgr = sprite.getPixelRGBA(0, x, y);
                r = (int)((double)r + Math.pow(FluidColorExtraction.red(abgr), 2.0));
                g = (int)((double)g + Math.pow(FluidColorExtraction.green(abgr), 2.0));
                b = (int)((double)b + Math.pow(FluidColorExtraction.blue(abgr), 2.0));
            }
        }
        return 0xFF000000 | FluidColorExtraction.sqrt(r / n) << 16 | FluidColorExtraction.sqrt(g / n) << 8 | FluidColorExtraction.sqrt(b / n);
    }

    private static TextureAtlasSprite getStillFluidTexture(Fluid fluid) {
        return TEXTURE.func_195424_a(fluid.getAttributes().getStillTexture());
    }

    public static TextureAtlasSprite getStillFluidTextureSafe(Fluid fluid) {
        TextureAtlasSprite stillFluidTexture = FluidColorExtraction.getStillFluidTexture(fluid);
        return stillFluidTexture == null ? FluidColorExtraction.getStillFluidTexture(DEFAULT) : stillFluidTexture;
    }

    private static int red(int abgr) {
        return abgr & 0xFF;
    }

    private static int green(int abgr) {
        return abgr >> 8 & 0xFF;
    }

    private static int blue(int abgr) {
        return abgr >> 16 & 0xFF;
    }

    private static int sqrt(int i) {
        return (int)Math.sqrt(i);
    }
}

