/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.vanilla.tiles;

import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.styles.Styles;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.SmokerTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FurnaceInfo
implements ITileInfo<AbstractFurnaceTileEntity> {
    private static final IIconStyle FIRE_STYLE = new IconStyle().bounds(8, 8).textureBounds(8, 64);
    private static final ResourceLocation FIRE_ICON = new ResourceLocation("minecraft:textures/block/campfire_fire.png");

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData hitData, @Nonnull AbstractFurnaceTileEntity tile) {
        int burnTime = tile.field_214013_b.func_221476_a(0);
        int cookTime = tile.field_214013_b.func_221476_a(2);
        int cookTimeTotal = tile.field_214013_b.func_221476_a(3);
        if (burnTime > 0) {
            probeInfo.horizontal().icon(FIRE_ICON, 0, (int)(world.func_82737_E() % 8L * 16L), FIRE_STYLE.getWidth(), FIRE_STYLE.getHeight(), FIRE_STYLE).text(CompoundText.create().label("topaddons.vanilla:fuel").text(": ").style(TextStyleClass.INFO).text((ITextComponent)new TranslationTextComponent("topaddons:n_ticks", new Object[]{burnTime})));
        }
        if (cookTime > 0) {
            String prefixWord = tile instanceof SmokerTileEntity ? "topaddons.vanilla:smoking" : "topaddons.vanilla:smelting";
            probeInfo.progress(100 * cookTime / cookTimeTotal, 100, Styles.machineProgress(player, prefixWord).alternateFilledColor(-8947849));
        }
    }
}

