/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.industrialforegoing;

import com.buuz135.industrial.block.agriculturehusbandry.tile.MobDuplicatorTile;
import com.google.common.collect.ImmutableMultimap;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import io.github.drmanganese.topaddons.addons.TopAddon;
import io.github.drmanganese.topaddons.addons.industrialforegoing.tiles.IndustrialActiveTileInfo;
import io.github.drmanganese.topaddons.addons.industrialforegoing.tiles.MobDuplicatorTileInfo;
import io.github.drmanganese.topaddons.api.IAddonBlocks;
import io.github.drmanganese.topaddons.api.IAddonConfig;
import io.github.drmanganese.topaddons.api.ITileInfo;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class IndustrialForegoingAddon
extends TopAddon
implements IAddonBlocks,
IAddonConfig {
    private final ImmutableMultimap<Class<? extends TileEntity>, ITileInfo> TILES = ImmutableMultimap.of(ActiveTile.class, (Object)new IndustrialActiveTileInfo(), MobDuplicatorTile.class, (Object)new MobDuplicatorTileInfo());
    public static ForgeConfigSpec.BooleanValue colorTinyProgressBackground;

    public IndustrialForegoingAddon() {
        super("industrialforegoing");
    }

    public static Optional<IItemHandler> getFirstItemHandlerFromTile(TileEntity tile) {
        for (Direction direction : Direction.values()) {
            Optional itemHandler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).filter(i -> i.getSlots() > 0);
            if (!itemHandler.isPresent()) continue;
            return itemHandler;
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public ImmutableMultimap<Class<? extends TileEntity>, ITileInfo> getTileInfos() {
        return this.TILES;
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder, ModConfig.Type type) {
        if (type == ModConfig.Type.CLIENT) {
            builder.push(this.name);
            colorTinyProgressBackground = builder.comment(new String[]{"Color the background of tiny progress bars with the GUI's progress bar color", "Replaces the default machine progress in the forge section"}).define("colorTinyProgressBackground", true);
            builder.pop();
        }
    }

    @Override
    public List<ForgeConfigSpec.ConfigValue<?>> getClientConfigValuesToSync() {
        return Collections.singletonList(colorTinyProgressBackground);
    }
}

