/*
 * Decompiled with CFR 0.152.
 */
package io.github.drmanganese.topaddons.addons.forge;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import io.github.drmanganese.topaddons.addons.TopAddon;
import io.github.drmanganese.topaddons.addons.forge.tiles.FluidHandlerTileInfo;
import io.github.drmanganese.topaddons.api.IAddonBlocks;
import io.github.drmanganese.topaddons.api.IAddonConfig;
import io.github.drmanganese.topaddons.api.IAddonConfigProviders;
import io.github.drmanganese.topaddons.api.IAddonElements;
import io.github.drmanganese.topaddons.api.ITileConfigProvider;
import io.github.drmanganese.topaddons.api.ITileInfo;
import io.github.drmanganese.topaddons.capabilities.ElementSync;
import io.github.drmanganese.topaddons.config.ColorValue;
import io.github.drmanganese.topaddons.config.Config;
import io.github.drmanganese.topaddons.elements.forge.FluidGaugeElement;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ITheOneProbe;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeAddon
extends TopAddon
implements IAddonBlocks,
IAddonElements,
IAddonConfig,
IAddonConfigProviders {
    public static final String GAUGE_ELEMENT_ID = "fluid_gauge";
    public static ForgeConfigSpec.EnumValue<FluidTextureAlignment> gaugeFluidTextureAlignment;
    public static ForgeConfigSpec.EnumValue<FluidColorAlgorithm> gaugeFluidColorAlgorithm;
    public static ForgeConfigSpec.IntValue gaugeFluidColorTransparency;
    public static ForgeConfigSpec.BooleanValue gaugeRenderFluidTexture;
    public static ForgeConfigSpec.BooleanValue gaugeShowCapacity;
    public static ForgeConfigSpec.BooleanValue gaugeRounded;
    public static ColorValue gaugeBackgroundColor;
    public static ColorValue gaugeBorderColor;
    public static ForgeConfigSpec.EnumValue<FluidGaugeChoice> fluidGaugeChoice;
    public static ForgeConfigSpec.BooleanValue gaugeUseCustomTankNames;
    public static ColorValue machineProgressBackgroundColor;
    public static ColorValue machineProgressBorderColor;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> gaugeModBlacklist;
    private static final List<? extends String> DEFAULT_BLACKLIST;

    public ForgeAddon() {
        super("forge");
    }

    @Override
    public void registerElements(ITheOneProbe probe) {
        ElementSync.registerElement(probe, GAUGE_ELEMENT_ID, FluidGaugeElement::new);
    }

    @Override
    @Nonnull
    public ImmutableMultimap<Class<? extends TileEntity>, ITileInfo> getTileInfos() {
        return ImmutableMultimap.of(TileEntity.class, (Object)FluidHandlerTileInfo.INSTANCE);
    }

    @Override
    public void buildConfig(ForgeConfigSpec.Builder builder, ModConfig.Type type) {
        builder.push(this.name);
        if (type == ModConfig.Type.CLIENT) {
            builder.push("fluidGauge");
            gaugeRounded = builder.comment("Show a rounded tank fluid gauge").define("gaugeRounded", true);
            gaugeBackgroundColor = new ColorValue((ForgeConfigSpec.ConfigValue<String>)builder.comment("Fluid gauge background color (try #557F0000 for BC red)").define("gaugeBackgroundColor", (Object)"#55666666", ColorValue::test));
            gaugeBorderColor = new ColorValue((ForgeConfigSpec.ConfigValue<String>)builder.comment("Fluid gauge border color (try #FF7F0000 for BC red)").define("gaugeBorderColor", (Object)"#ff666666", ColorValue::test));
            gaugeUseCustomTankNames = builder.comment("Allow certain tiles to show custom tank names").define("gaugeUseCustomTankNames", true);
            gaugeFluidColorAlgorithm = builder.comment("Which \"algorithm\" should be used to pick fluid colors (TOP_LEFT is sometimes lighter)").defineEnum("gaugeFluidColorAlgorithm", (Enum)FluidColorAlgorithm.AVERAGE_COLOR);
            fluidGaugeChoice = builder.comment("Which fluid gauges to show, BOTH and THE_ONE_PROBE_ONLY options also depend on the The One Probe \"showTankSetting\" configuration").defineEnum("fluidGaugeChoice", (Enum)FluidGaugeChoice.TOP_ADDONS_ONLY);
            gaugeShowCapacity = builder.comment("Show the tank's total capacity in the fluid gauge").define("gaugeShowCapacity", true);
            gaugeFluidColorTransparency = builder.comment("Fluid color transparency.").defineInRange("gaugeFluidColorTransparency", 255, 0, 255);
            gaugeRenderFluidTexture = builder.comment("Use the fluid's texture in the fluid gauge instead of the TOP lines.").define("gaugeRenderFluidTexture", true);
            gaugeFluidTextureAlignment = builder.comment("Alignment of the fluid's texture when gaugeRenderFluidTexture is enabled.").defineEnum("fluidTextureAlignment", (Enum)FluidTextureAlignment.MIDDLE);
            builder.pop();
            machineProgressBackgroundColor = new ColorValue((ForgeConfigSpec.ConfigValue<String>)builder.comment("Machine progress bar background color").define("machineProgressBackgroundColor", (Object)"#55666666", ColorValue::test));
            machineProgressBorderColor = new ColorValue((ForgeConfigSpec.ConfigValue<String>)builder.comment("Machine progress bar border color").define("machineProgressBorderColor", (Object)"#ff666666", ColorValue::test));
        }
        if (type == ModConfig.Type.COMMON) {
            gaugeModBlacklist = builder.comment("List of mod IDs for which no TOP Addons fluid gauge should be shown").defineList("gaugeModBlacklist", DEFAULT_BLACKLIST, o -> true);
        }
        builder.pop();
    }

    @Override
    public List<ForgeConfigSpec.ConfigValue<?>> getClientConfigValuesToSync() {
        return Lists.newArrayList((Object[])new ForgeConfigSpec.ConfigValue[]{fluidGaugeChoice, ForgeAddon.machineProgressBackgroundColor.configValue, ForgeAddon.machineProgressBorderColor.configValue, gaugeUseCustomTankNames});
    }

    @Override
    @Nonnull
    public ImmutableMap<Object, ITileConfigProvider> getBlockConfigProviders() {
        return ImmutableMap.of(TileEntity.class, (Object)FluidHandlerTileInfo.INSTANCE);
    }

    static {
        DEFAULT_BLACKLIST = Arrays.asList("mekanism", "mekanismgenerators", "fluidtank");
    }

    public static enum FluidTextureAlignment {
        TOP((minV, maxV, vSpace) -> minV, (minV, maxV, vSpace) -> Float.valueOf(minV.floatValue() + vSpace.floatValue())),
        MIDDLE((minV, maxV, vSpace) -> Float.valueOf(minV.floatValue() + (maxV.floatValue() - minV.floatValue() - vSpace.floatValue()) / 2.0f), (minV, maxV, vSpace) -> Float.valueOf(maxV.floatValue() - (maxV.floatValue() - minV.floatValue() - vSpace.floatValue()) / 2.0f)),
        SQUEEZE((minV, maxV, vSpace) -> minV, (minV, maxV, vSpace) -> maxV);

        public TriFunction<Float, Float, Float, Float> fv1;
        public TriFunction<Float, Float, Float, Float> fv2;

        private FluidTextureAlignment(TriFunction<Float, Float, Float, Float> fv1, TriFunction<Float, Float, Float, Float> fv2) {
            this.fv1 = fv1;
            this.fv2 = fv2;
        }

        @FunctionalInterface
        public static interface TriFunction<A, B, C, R> {
            public R apply(A var1, B var2, C var3);
        }
    }

    public static enum FluidColorAlgorithm {
        TOP_LEFT_COLOR,
        AVERAGE_COLOR;

    }

    public static enum FluidGaugeChoice {
        BOTH(false, false),
        THE_ONE_PROBE_ONLY(false, true),
        TOP_ADDONS_ONLY(true, false);

        public final boolean hideOriginal;
        public final boolean hideTopAddonsGauge;

        private FluidGaugeChoice(boolean hideOriginal, boolean hideTopAddonsGauge) {
            this.hideOriginal = hideOriginal;
            this.hideTopAddonsGauge = hideTopAddonsGauge;
        }

        public static FluidGaugeChoice getSyncedValueFor(PlayerEntity player) {
            return (FluidGaugeChoice)Config.getSyncedEnum(player, fluidGaugeChoice);
        }
    }
}

