/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.network.DraconicNetwork;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.server.ServerBossInfo;

public class ShieldedServerBossInfo
extends ServerBossInfo {
    private float shieldPower = 0.0f;
    private int crystals = 0;
    private boolean immune = false;

    public ShieldedServerBossInfo(ITextComponent name, BossInfo.Color color, BossInfo.Overlay overlay) {
        super(name, color, overlay);
    }

    public void setShieldPower(float shieldPower) {
        if (this.shieldPower != shieldPower) {
            this.shieldPower = shieldPower;
            if (this.func_201359_g()) {
                for (ServerPlayerEntity player : this.field_186762_h) {
                    DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 2, e -> e.writeFloat(this.shieldPower));
                }
            }
        }
    }

    public void setCrystals(int crystals) {
        if (this.crystals != crystals) {
            this.crystals = crystals;
            if (this.func_201359_g()) {
                for (ServerPlayerEntity player : this.field_186762_h) {
                    DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 3, e -> e.writeByte(this.crystals));
                }
            }
        }
    }

    public void setImmune(boolean immune) {
        if (this.immune != immune) {
            this.immune = immune;
            if (this.func_201359_g()) {
                for (ServerPlayerEntity player : this.field_186762_h) {
                    DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 4, e -> e.writeBoolean(this.immune));
                }
            }
        }
    }

    public void func_186758_d(boolean visible) {
        boolean prev = this.func_201359_g();
        super.func_186758_d(visible);
        if (prev != visible) {
            for (ServerPlayerEntity player : this.field_186762_h) {
                if (visible) {
                    DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
                    continue;
                }
                DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 1, null);
            }
        }
    }

    public void func_186760_a(ServerPlayerEntity player) {
        if (this.field_186762_h.add(player) && this.func_201359_g()) {
            player.field_71135_a.func_147359_a((IPacket)new SUpdateBossInfoPacket(SUpdateBossInfoPacket.Operation.ADD, (BossInfo)this));
            DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 0, e -> e.writeFloat(this.shieldPower).writeByte(this.crystals).writeBoolean(this.immune));
        }
    }

    public void func_186761_b(ServerPlayerEntity player) {
        if (this.field_186762_h.remove(player) && this.func_201359_g()) {
            player.field_71135_a.func_147359_a((IPacket)new SUpdateBossInfoPacket(SUpdateBossInfoPacket.Operation.REMOVE, (BossInfo)this));
            DraconicNetwork.sendBossShieldPacket(player, this.func_186737_d(), 1, null);
        }
    }
}

