/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.world;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ChaosWorldGenHandler;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="draconicevolution", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DEWorldGen {
    private static Logger LOGGER = DraconicEvolution.LOGGER;
    public static final RuleTest BASE_STONE_END = new BlockMatchRuleTest(Blocks.field_150377_bs);

    @SubscribeEvent
    public static void biomeLoading(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.THEEND) {
            if (DEConfig.enableOreEnd) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(BASE_STONE_END, DEContent.ore_draconium_end.func_176223_P(), DEConfig.veinSizeEnd)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 80))).func_242728_a()).func_242731_b(DEConfig.veinsPerChunkEnd));
            }
            event.getGeneration().func_242513_a(GenerationStage.Decoration.RAW_GENERATION, new ConfiguredFeature((Feature)new Feature<NoFeatureConfig>(NoFeatureConfig.field_236558_a_){

                public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
                    return ChaosWorldGenHandler.generateChunk(this, reader, generator, rand, pos);
                }
            }, (IFeatureConfig)NoFeatureConfig.field_202429_e));
        } else if (event.getCategory() == Biome.Category.NETHER && DEConfig.enableOreNether) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, DEContent.ore_draconium_nether.func_176223_P(), DEConfig.veinSizeNether)).func_242729_a(10)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(4, 4, DEConfig.maxOreHeightNether))));
        } else if (DEConfig.enableOreOverworld) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, DEContent.ore_draconium_overworld.func_176223_P(), DEConfig.veinSizeOverworld)).func_242729_a(10)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(4, 4, DEConfig.maxOreHeightOverworld))));
        }
    }
}

