/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortalClient;
import com.brandon3055.draconicevolution.client.ClientProxy;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.ExplosionFX;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, IClientPlayNetHandler handler) {
        switch (packet.getType()) {
            case 1: {
                CrystalUpdateBatcher.handleBatchedData((MCDataInput)packet);
                break;
            }
            case 3: {
                ClientPacketHandler.handleExplosionEffect(mc, packet.readPos(), packet.readVarInt(), packet.readBoolean());
                break;
            }
            case 4: {
                ClientPacketHandler.handleImpactEffect(mc, packet.readPos(), packet.readByte());
                break;
            }
            case 5: {
                ClientPacketHandler.handleUndyingActivation(mc, packet.readVarInt(), (Item)packet.readRegistryId());
                break;
            }
            case 6: {
                ClientPacketHandler.handleBlinkEffect(mc, packet.readVarInt(), packet.readFloat());
                break;
            }
            case 7: {
                ClientPacketHandler.handleStaffEffect(mc, (MCDataInput)packet);
                break;
            }
            case 8: {
                ClientPacketHandler.handleGuardianBeam(mc, (MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handleGuardianPacket(mc, (MCDataInput)packet);
                break;
            }
            case 10: {
                CustomBossInfoHandler.handlePacket((MCDataInput)packet);
                break;
            }
            case 11: {
                this.handleDislocatorTeleported(mc);
            }
        }
    }

    public static void handleExplosionEffect(Minecraft mc, BlockPos pos, int radius, boolean reload) {
        if (reload) {
            mc.field_71438_f.func_72712_a();
        } else {
            ExplosionFX explosionFX = new ExplosionFX((ClientWorld)BrandonsCore.proxy.getClientWorld(), Vec3D.getCenter((BlockPos)pos), radius);
            mc.field_71452_i.func_78873_a((Particle)explosionFX);
        }
    }

    public static void handleImpactEffect(Minecraft mc, BlockPos pos, int type) {
        if (mc.field_71441_e == null) {
            return;
        }
        if (type == 0) {
            int size = 4;
            double speed = 1.0;
            double x = (double)pos.func_177958_n() + 0.5;
            double y = (double)pos.func_177956_o() + 0.5;
            double z = (double)pos.func_177952_p() + 0.5;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (mc.field_71441_e.field_73012_v.nextDouble() - mc.field_71441_e.field_73012_v.nextDouble()) * 0.5;
                        double d4 = (double)i + (mc.field_71441_e.field_73012_v.nextDouble() - mc.field_71441_e.field_73012_v.nextDouble()) * 0.5;
                        double d5 = (double)k + (mc.field_71441_e.field_73012_v.nextDouble() - mc.field_71441_e.field_73012_v.nextDouble()) * 0.5;
                        double d6 = (double)MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5)) / speed + mc.field_71441_e.field_73012_v.nextGaussian() * 6.0;
                        ClientPacketHandler.createParticle(mc, x, y, z, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
            mc.field_71452_i.func_199280_a((IParticleData)ParticleTypes.field_197626_s, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void createParticle(Minecraft mc, double x, double y, double z, double motionX, double motionY, double motionZ) {
        mc.field_71452_i.func_199280_a((IParticleData)DEParticles.guardian_projectile, x, y, z, motionX, motionY, motionZ);
    }

    private static void handleUndyingActivation(Minecraft mc, int id, Item item) {
        if (mc.field_71441_e == null) {
            return;
        }
        Entity entity = mc.field_71441_e.func_73045_a(id);
        if (entity != null) {
            mc.field_71452_i.func_199281_a(entity, (IParticleData)ParticleTypes.field_197604_O, 30);
            if (entity == mc.field_71439_g) {
                ClientProxy.hudElement.popTotem();
            }
        }
    }

    private static void handleBlinkEffect(Minecraft mc, int id, float distance) {
        Entity entity;
        if (mc.field_71441_e == null || (entity = mc.field_71441_e.func_73045_a(id)) == null) {
            return;
        }
        Vector3d vec = entity.func_70040_Z();
        Vector3d pos = entity.func_174824_e(1.0f);
        for (int i = 0; i < 100; ++i) {
            float offset = mc.field_71441_e.field_73012_v.nextFloat();
            float speed = (1.0f - offset) * distance;
            speed *= speed;
            Vector3d spawnPos = pos.func_178787_e(vec.func_216372_d((double)(speed * 10.0f), (double)(speed * 10.0f), (double)(speed * 10.0f)));
            double x = spawnPos.field_72450_a + (mc.field_71441_e.field_73012_v.nextGaussian() - 0.5) * (double)offset;
            double y = spawnPos.field_72448_b + (mc.field_71441_e.field_73012_v.nextGaussian() - 0.5) * (double)offset;
            double z = spawnPos.field_72449_c + (mc.field_71441_e.field_73012_v.nextGaussian() - 0.5) * (double)offset;
            mc.field_71441_e.func_195594_a((IParticleData)DEParticles.blink, x, y, z, vec.field_72450_a * (double)speed, vec.field_72448_b * (double)speed, vec.field_72449_c * (double)speed);
        }
    }

    private static void handleStaffEffect(Minecraft mc, MCDataInput data) {
        Entity entity;
        byte type = data.readByte();
        int entityID = data.readVarInt();
        if (mc.field_71441_e != null && (entity = mc.field_71441_e.func_73045_a(entityID)) instanceof LivingEntity) {
            switch (type) {
                case 0: {
                    DefaultStaffDmgMod.handleEffect((LivingEntity)entity, data);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private static void handleGuardianBeam(Minecraft mc, MCDataInput data) {
        Vector3 source = data.readVector();
        Vector3 target = data.readVector();
        float power = data.readFloat();
        double dist = MathUtils.distance((Vector3)source, (Vector3)target);
        if (mc.field_71441_e == null) {
            return;
        }
        for (double d = 0.0; d < dist; d += 2.0) {
            Vector3 pos = MathUtils.interpolateVec3((Vector3)source, (Vector3)target, (double)((d - 1.0 + mc.field_71441_e.field_73012_v.nextDouble() * 2.0) / dist));
            mc.field_71441_e.func_195590_a((IParticleData)DEParticles.guardian_beam, true, pos.x, pos.y, pos.z, (double)power, 0.0, 0.0);
        }
    }

    private static void handleGuardianPacket(Minecraft mc, MCDataInput data) {
        if (mc.field_71441_e == null) {
            return;
        }
        Entity e = mc.field_71441_e.func_73045_a(data.readInt());
        if (!(e instanceof DraconicGuardianEntity)) {
            return;
        }
        DraconicGuardianEntity guardian = (DraconicGuardianEntity)e;
        byte phaseID = data.readByte();
        PhaseManager phaseManager = guardian.getPhaseManager();
        IPhase phase = phaseManager.getCurrentPhase();
        if (phase.getType().getId() != phaseID) {
            return;
        }
        byte function = data.readByte();
        phase.handlePacket(data, function);
    }

    private void handleDislocatorTeleported(Minecraft mc) {
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        BlockPos playerPos = player.func_233580_cy_();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)playerPos.func_177982_a(-1, -1, -1), (BlockPos)playerPos.func_177982_a(1, 1, 1))) {
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (!(tile instanceof TilePortalClient)) continue;
            ((TilePortalClient)tile).clientArrived((PlayerEntity)player);
        }
    }
}

