/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.MultiBlockStorage;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.lib.WTFException;
import com.brandon3055.draconicevolution.world.EnergyCoreStructure;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class EnergyCoreBuilder
implements IProcess {
    private final TileEnergyCore core;
    private final PlayerEntity player;
    private boolean isDead = false;
    private Map<BlockPos, BlockState> workList = new HashMap<BlockPos, BlockState>();
    private LinkedList<BlockPos> workOrder = new LinkedList();
    private World world;

    public EnergyCoreBuilder(TileEnergyCore core, PlayerEntity player) {
        this.core = core;
        this.player = player;
        this.world = core.func_145831_w();
        this.buildWorkList();
    }

    private void buildWorkList() {
        EnergyCoreStructure structure = this.core.coreStructure;
        MultiBlockStorage storage = structure.getStorageForTier(this.core.tier.get());
        BlockPos start = this.core.func_174877_v().func_177971_a((Vector3i)structure.getCoreOffset(this.core.tier.get()));
        HashMap structureBlocks = new HashMap();
        storage.forEachBlock(start, (key1, value) -> {
            HashMap<String, Block> blockCache = new HashMap<String, Block>();
            structureBlocks.put(key1, blockCache.computeIfAbsent((String)value, s -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(value))));
        });
        World world = this.core.func_145831_w();
        for (BlockPos key : structureBlocks.keySet()) {
            Block targetBlock = (Block)structureBlocks.get(key);
            if (targetBlock == null) continue;
            if (world.func_175623_d(key)) {
                this.workList.put(key, targetBlock.func_176223_P());
                continue;
            }
            BlockState state = world.func_180495_p(key);
            if (state.func_177230_c() == targetBlock) continue;
            this.isDead = true;
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("ecore.de.assemble_found_invalid.txt", new Object[]{state.func_177230_c().func_149739_a(), key.toString()}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return;
        }
        this.workOrder.addAll(this.workList.keySet());
        this.workOrder.sort(Comparator.comparingInt(value -> (int)value.func_177951_i((Vector3i)this.core.func_174877_v())));
    }

    public void updateProcess() {
        if (this.workOrder.isEmpty() || !this.player.func_70089_S()) {
            this.isDead = true;
            return;
        }
        BlockPos pos = this.workOrder.poll();
        BlockState state = this.workList.get(pos);
        if (!this.world.func_175623_d(pos)) {
            if (this.world.func_180495_p(pos).func_177230_c() == state.func_177230_c()) {
                return;
            }
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("ecore.de.assemble_error_expected_air.txt", new Object[]{pos.toString()}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            this.isDead = true;
            return;
        }
        ItemStack required = new ItemStack((IItemProvider)state.func_177230_c());
        if (this.player.field_71075_bZ.field_75098_d || this.extractItem(required)) {
            this.world.func_175656_a(pos, state);
            SoundType soundtype = state.func_177230_c().getSoundType(state, (IWorldReader)this.world, pos, (Entity)this.player);
            this.world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        } else {
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("ecore.de.assemble_missing_required.txt", new Object[]{state.func_177230_c().func_149739_a()}).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            this.isDead = true;
        }
    }

    private boolean extractItem(ItemStack toExtract) {
        LazyOptional opHandler = this.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (opHandler.isPresent()) {
            IItemHandler handler = (IItemHandler)opHandler.orElseThrow(WTFException::new);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extracted;
                ItemStack inSlot = handler.getStackInSlot(i);
                if (inSlot.func_190926_b() || inSlot.func_77973_b() != toExtract.func_77973_b() || (extracted = handler.extractItem(i, 1, false)).func_190926_b() || extracted.func_77973_b() != toExtract.func_77973_b()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

