/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.gui.GuiDislocator;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;

public class DislocatorAdvanced
extends Dislocator {
    public DislocatorAdvanced(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        DislocatorTarget location = this.getTargetPos(stack, player.field_70170_p);
        int fuel = this.getFuel(stack);
        if (!player.field_71075_bZ.field_75098_d && fuel <= 0) {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.no_fuel").func_240699_a_(TextFormatting.RED));
            return true;
        }
        if (entity instanceof PlayerEntity) {
            if (entity.func_225608_bj_()) {
                if (this.useFuel(stack, player)) {
                    this.dislocateEntity(stack, (Entity)player, entity, location);
                }
            } else {
                this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.player_allow"));
            }
            return true;
        }
        if (!entity.func_184222_aU() || !(entity instanceof LivingEntity)) {
            return true;
        }
        if (this.useFuel(stack, player)) {
            this.dislocateEntity(stack, (Entity)player, entity, location);
            this.messageUser((Entity)player, (ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"dislocate.draconicevolution.entity_sent_to", (Object[])new Object[0]) + " " + location.getReadableName(false)).func_240699_a_(TextFormatting.GREEN));
        }
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        DislocatorTarget location = this.getTargetPos(stack, player.field_70170_p);
        boolean blink = this.getBlinkMode(stack);
        if (player.func_225608_bj_() || location == null && !blink) {
            if (world.field_72995_K) {
                this.openGui(stack, player);
            }
        } else if (!world.field_72995_K) {
            if (blink) {
                this.handleBlink((ServerPlayerEntity)player, stack, false);
            } else {
                this.handleTeleport(player, stack, location, false);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openGui(ItemStack stack, PlayerEntity player) {
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiDislocator(stack.func_200301_q(), player));
    }

    private void handleTeleport(PlayerEntity player, ItemStack stack, TargetPos targetPos, boolean showFuel) {
        int fuel = this.getFuel(stack);
        if (!player.field_71075_bZ.field_75098_d && fuel <= 0) {
            this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.no_fuel").func_240699_a_(TextFormatting.RED));
        } else if (this.useFuel(stack, player)) {
            this.dislocateEntity(stack, (Entity)player, (Entity)player, targetPos);
            if (showFuel) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.teleport_fuel").func_240702_b_(" " + this.getFuel(stack)).func_240699_a_(TextFormatting.WHITE), true);
            }
        }
    }

    private void handleBlink(ServerPlayerEntity player, ItemStack stack, boolean showFuel) {
        if (!player.field_71075_bZ.field_75098_d) {
            int blinkFuel = stack.func_196082_o().func_74771_c("blink_fuel");
            if (blinkFuel <= 0) {
                if (!this.useFuel(stack, (PlayerEntity)player)) {
                    this.messageUser((Entity)player, (ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.no_fuel").func_240699_a_(TextFormatting.RED));
                    return;
                }
                blinkFuel = DEConfig.dislocatorBlinksPerPearl;
            }
            stack.func_196082_o().func_74774_a("blink_fuel", (byte)(--blinkFuel));
            if (showFuel) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.teleport_fuel").func_240702_b_(" " + this.getFuel(stack)).func_240699_a_(TextFormatting.WHITE), true);
            }
        }
        Vector3d playerVec = player.func_174824_e(1.0f);
        double range = DEConfig.dislocatorBlinkRange;
        Vector3d endVec = playerVec.func_178787_e(player.func_70040_Z().func_216372_d(range, range, range));
        RayTraceContext context = new RayTraceContext(playerVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)player);
        BlockRayTraceResult result = player.field_70170_p.func_217299_a(context);
        player.field_70170_p.func_184148_a(null, playerVec.field_72450_a, playerVec.field_72448_b, playerVec.field_72449_c, DESounds.blink, SoundCategory.PLAYERS, 1.0f, 1.0f);
        DraconicNetwork.sendBlinkEffect(player, (float)(playerVec.func_72438_d(endVec) / range));
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            if (player.func_184613_cA()) {
                player.field_71135_a.func_175089_a(endVec.field_72450_a, endVec.field_72448_b, endVec.field_72449_c, player.field_70177_z, player.field_70125_A, (Set)Sets.newHashSet((Object[])new SPlayerPositionLookPacket.Flags[]{SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z}));
                player.func_70034_d(player.field_70177_z);
            } else {
                TeleportUtils.teleportEntity((Entity)player, (RegistryKey)player.field_70170_p.func_234923_W_(), (double)endVec.field_72450_a, (double)endVec.field_72448_b, (double)endVec.field_72449_c);
            }
        } else {
            BlockPos pos = result.func_216350_a().func_177972_a(result.func_216354_b());
            Vec3D vec = new Vec3D(pos).add(0.5, 0.0, 0.5);
            switch (result.func_216354_b()) {
                case DOWN: 
                case UP: {
                    break;
                }
                default: {
                    if (!player.field_70170_p.func_180495_p(pos.func_177977_b()).func_196957_g((IBlockReader)player.field_70170_p, pos.func_177977_b(), PathType.AIR)) break;
                    vec.y -= 1.0;
                }
            }
            TeleportUtils.teleportEntity((Entity)player, (RegistryKey)player.field_70170_p.func_234923_W_(), (double)vec.x, (double)vec.y, (double)vec.z);
        }
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), DESounds.blink, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @Override
    public DislocatorTarget getTargetPos(ItemStack stack, @Nullable World world) {
        return (DislocatorTarget)((Object)DataUtils.safeGet(this.getTargetList(stack), (int)this.getSelectedIndex(stack)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DislocatorTarget selected = this.getTargetPos(stack, world);
        int fuel = this.getFuel(stack);
        if (selected != null) {
            tooltip.add((ITextComponent)new StringTextComponent(selected.getName()).func_240699_a_(TextFormatting.GOLD));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.fuel").func_240702_b_(" " + fuel).func_240699_a_(TextFormatting.WHITE));
        tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.to_open_gui").func_240701_a_(new TextFormatting[]{TextFormatting.DARK_PURPLE, TextFormatting.ITALIC}));
    }

    @Override
    public void generateHudText(ItemStack stack, PlayerEntity player, List<ITextComponent> displayList) {
        DislocatorTarget location = this.getTargetPos(stack, player.field_70170_p);
        if (location != null) {
            displayList.add((ITextComponent)new StringTextComponent(location.getName()));
        }
        displayList.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.fuel").func_240702_b_(" " + this.getFuel(stack)));
    }

    @Override
    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public int getFuel(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("fuel");
    }

    public void setFuel(ItemStack stack, int value) {
        stack.func_196082_o().func_74768_a("fuel", value);
    }

    public boolean useFuel(ItemStack stack, PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int fuel = this.getFuel(stack);
        if (fuel > 0) {
            this.setFuel(stack, fuel - 1);
            return true;
        }
        return false;
    }

    public List<DislocatorTarget> getTargetList(ItemStack stack) {
        ListNBT targets = stack.func_196082_o().func_150295_c("locations", 10);
        ArrayList<DislocatorTarget> list = new ArrayList<DislocatorTarget>();
        targets.forEach(inbt -> list.add(new DislocatorTarget((CompoundNBT)inbt)));
        return list;
    }

    public void setTargetList(ItemStack stack, List<DislocatorTarget> targets) {
        ListNBT list = new ListNBT();
        targets.forEach(e -> list.add((Object)e.writeToNBT()));
        stack.func_196082_o().func_218657_a("locations", (INBT)list);
    }

    public int getSelectedIndex(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("selected");
    }

    public void setSelectedIndex(ItemStack stack, int index) {
        stack.func_196082_o().func_74768_a("selected", index);
    }

    public boolean getBlinkMode(ItemStack stack) {
        return stack.func_196082_o().func_74767_n("blink");
    }

    public void setBlinkMode(ItemStack stack, boolean blink) {
        stack.func_196082_o().func_74757_a("blink", blink);
    }

    public void handleClientAction(ServerPlayerEntity player, ItemStack stack, MCDataInput input) {
        byte action = input.readByte();
        int selectIndex = this.getSelectedIndex(stack);
        LinkedList<DislocatorTarget> list = new LinkedList<DislocatorTarget>(this.getTargetList(stack));
        DislocatorTarget selected = selectIndex >= 0 && selectIndex < list.size() ? list.get(selectIndex) : null;
        switch (action) {
            case 0: {
                byte mode = input.readByte();
                int index = input.readVarInt();
                DislocatorTarget newPoint = new DislocatorTarget((Entity)player).setName(input.readString());
                if (mode == 1 || index < 0) {
                    list.addFirst(newPoint);
                } else if (mode == 2 || index >= list.size()) {
                    list.addLast(newPoint);
                } else {
                    list.add(index, newPoint);
                }
                selected = newPoint;
                break;
            }
            case 1: {
                DataUtils.safeRemove(list, (int)input.readVarInt());
                break;
            }
            case 2: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.setName(input.readString()));
                break;
            }
            case 3: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.setLocked(input.readBoolean()));
                break;
            }
            case 4: {
                selected = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)input.readVarInt()));
                break;
            }
            case 5: {
                this.setBlinkMode(stack, input.readBoolean());
                break;
            }
            case 6: {
                this.addFuel(stack, (PlayerEntity)player, input.readBoolean(), input.readBoolean());
                return;
            }
            case 7: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> e.update((Entity)player));
                break;
            }
            case 8: {
                DataUtils.ifPresent(list, (int)input.readVarInt(), e -> this.handleTeleport((PlayerEntity)player, stack, (TargetPos)e, true));
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                if (list.size() == 0) {
                    return;
                }
                if (selected == null) {
                    return;
                }
                int newIndex = input.readVarInt();
                if (newIndex > selectIndex) {
                    --newIndex;
                }
                if (newIndex < 0 || newIndex >= list.size()) {
                    return;
                }
                list.remove((Object)selected);
                list.add(newIndex, selected);
                break;
            }
            case 11: {
                if (list.size() == 0) {
                    return;
                }
                this.handleTeleport((PlayerEntity)player, stack, selected, true);
                break;
            }
            case 12: {
                this.handleBlink(player, stack, true);
                break;
            }
            case 13: {
                if (list.size() == 0) {
                    return;
                }
                selected = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex += input.readBoolean() ? 1 : -1, list.size())));
                if (selected == null) break;
                DislocatorTarget up = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex - 1, list.size())));
                DislocatorTarget down = (DislocatorTarget)((Object)DataUtils.safeGet(list, (int)Math.floorMod(selectIndex + 1, list.size())));
                if (up != null) {
                    ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new StringTextComponent(up.getName()).func_240699_a_(TextFormatting.GRAY), (int)391);
                }
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new StringTextComponent(TextFormatting.GREEN + ">" + TextFormatting.GOLD + selected.getName() + TextFormatting.GREEN + "<"), (int)392);
                if (down == null) break;
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new StringTextComponent(down.getName()).func_240699_a_(TextFormatting.GRAY), (int)393);
                break;
            }
            default: {
                return;
            }
        }
        this.setTargetList(stack, list);
        if (selected != null) {
            if (list.contains((Object)selected)) {
                this.setSelectedIndex(stack, list.indexOf((Object)selected));
            } else if (selectIndex > 0 && selectIndex - 1 < list.size()) {
                this.setSelectedIndex(stack, selectIndex - 1);
            }
        } else {
            this.setSelectedIndex(stack, 0);
        }
    }

    public void addFuel(ItemStack dislocator, PlayerEntity player, boolean fullStack, boolean allStacks) {
        int max = DEConfig.dislocatorMaxFuel - this.getFuel(dislocator);
        int wanted = allStacks ? max : Math.min(max, fullStack ? 16 : 1);
        int added = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && wanted > 0; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!Tags.Items.ENDER_PEARLS.func_230235_a_((Object)stack.func_77973_b())) continue;
            while (!stack.func_190926_b() && wanted > 0) {
                --wanted;
                stack.func_190918_g(1);
                ++added;
            }
        }
        this.setFuel(dislocator, this.getFuel(dislocator) + added);
    }

    public static ItemStack findDislocator(PlayerEntity player) {
        ItemStack stack = HandHelper.getItem((PlayerEntity)player, (Item)DEContent.dislocator_advanced);
        if (!stack.func_190926_b()) {
            return stack;
        }
        stack = EquipmentManager.findItem(DEContent.dislocator_advanced, (LivingEntity)player);
        if (!stack.func_190926_b()) {
            return stack;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_() - player.field_71071_by.field_184439_c.size(); ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != DEContent.dislocator_advanced) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static class DislocatorTarget
    extends TargetPos {
        private String name;
        private boolean locked;

        public DislocatorTarget() {
        }

        public DislocatorTarget(Entity entity) {
            super(entity);
        }

        public DislocatorTarget(CompoundNBT nbt) {
            super(nbt);
        }

        public DislocatorTarget(double x, double y, double z, RegistryKey<World> dimension) {
            super(x, y, z, dimension);
        }

        public DislocatorTarget(double x, double y, double z, RegistryKey<World> dimension, float pitch, float yaw) {
            super(x, y, z, dimension, pitch, yaw);
        }

        public DislocatorTarget setName(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name == null ? "" : this.name;
        }

        public void setLocked(boolean locked) {
            this.locked = locked;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public CompoundNBT writeToNBT(CompoundNBT nbt) {
            nbt.func_74778_a("name", this.name);
            nbt.func_74757_a("lock", this.locked);
            return super.writeToNBT(nbt);
        }

        public void readFromNBT(CompoundNBT nbt) {
            super.readFromNBT(nbt);
            this.name = nbt.func_74779_i("name");
            this.locked = nbt.func_74767_n("lock");
        }

        public void write(MCDataOutput output) {
            super.write(output);
            output.writeString(this.name);
            output.writeBoolean(this.locked);
        }

        public void read(MCDataInput input) {
            super.read(input);
            this.name = input.readString();
            this.locked = input.readBoolean();
        }
    }
}

