/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.entity.PersistentItemEntity;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorSaveData;
import com.brandon3055.draconicevolution.handlers.dislocator.DislocatorTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.GroundTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundDislocator
extends Dislocator {
    public BoundDislocator(Item.Properties properties) {
        super(properties);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group) && (this == DEContent.dislocator_player_unbound || this == DEContent.dislocator_p2p_unbound)) {
            list.add((Object)new ItemStack((IItemProvider)this));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world instanceof ServerWorld && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack) && entity instanceof PlayerEntity) {
            DislocatorSaveData.updateLinkTarget(world, stack, new PlayerTarget((PlayerEntity)entity));
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.field_70170_p instanceof ServerWorld && TimeKeeper.getServerTick() % 20 == 0 && BoundDislocator.isValid(stack) && !BoundDislocator.isPlayer(stack)) {
            DislocatorSaveData.updateLinkTarget(entity.field_70170_p, stack, new GroundTarget(entity));
        }
        return false;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.field_70170_p);
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_player").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_target").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return true;
        }
        if (!entity.func_184222_aU() || !(entity instanceof LivingEntity)) {
            return true;
        }
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        location.setPitch(player.field_70125_A);
        location.setYaw(player.field_70177_z);
        BoundDislocator.notifyArriving(stack, player.field_70170_p, entity);
        location.teleport(entity);
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return true;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_70170_p.field_72995_K) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (stack.func_77973_b() == DEContent.dislocator_p2p_unbound) {
            UUID linkID = UUID.randomUUID();
            ItemStack boundA = BoundDislocator.createP2PDislocator(linkID);
            ItemStack boundB = BoundDislocator.createP2PDislocator(linkID);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            InventoryUtils.givePlayerStack((PlayerEntity)player, (ItemStack)boundA);
            InventoryUtils.givePlayerStack((PlayerEntity)player, (ItemStack)boundB);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (stack.func_77973_b() == DEContent.dislocator_player_unbound) {
            ItemStack bound = new ItemStack((IItemProvider)DEContent.dislocator_player);
            BoundDislocator.setPlayerID(bound, player.func_110124_au());
            BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
            ItemNBTHelper.setString((ItemStack)bound, (String)"player_name", (String)player.func_200200_C_().getString());
            player.func_184611_a(hand, ItemStack.field_190927_a);
            InventoryUtils.givePlayerStack((PlayerEntity)player, (ItemStack)bound);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        TargetPos location = this.getTargetPos(stack, world);
        if (location == null) {
            if (BoundDislocator.isPlayer(stack)) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_player").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.cant_find_target").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        location.setPitch(player.field_70125_A);
        location.setYaw(player.field_70177_z);
        BoundDislocator.notifyArriving(stack, player.field_70170_p, (Entity)player);
        location.teleport((Entity)player);
        BCoreNetwork.sendSound((World)player.field_70170_p, (BlockPos)player.func_233580_cy_(), (SoundEvent)DESounds.portal, (SoundCategory)SoundCategory.PLAYERS, (float)0.1f, (float)(player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f), (boolean)false);
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public static boolean isPlayer(ItemStack stack) {
        return stack.func_77973_b() == DEContent.dislocator_player;
    }

    public static boolean isP2P(ItemStack stack) {
        return stack.func_77973_b() == DEContent.dislocator_p2p;
    }

    public static UUID getPlayerID(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"player_id", null);
    }

    public static void setPlayerID(ItemStack stack, UUID playerID) {
        stack.func_196082_o().func_186854_a("player_id", playerID);
    }

    public static boolean isValid(ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (stack.func_77973_b() instanceof BoundDislocator) {
            return compound != null && BoundDislocator.getLinkId(stack) != null && BoundDislocator.getDislocatorId(stack) != null;
        }
        return false;
    }

    @Nullable
    public static UUID getDislocatorId(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"stack_id", null);
    }

    @Nullable
    public static UUID getLinkId(ItemStack stack) {
        return ItemNBTHelper.getUUID((ItemStack)stack, (String)"link_id", null);
    }

    private static void setDislocatorId(ItemStack stack, UUID dislocatorID) {
        ItemNBTHelper.setUUID((ItemStack)stack, (String)"stack_id", (UUID)dislocatorID);
    }

    private static void setLinkId(ItemStack stack, UUID linkID) {
        ItemNBTHelper.setUUID((ItemStack)stack, (String)"link_id", (UUID)linkID);
    }

    private static ItemStack createP2PDislocator(UUID linkID) {
        ItemStack stack = new ItemStack((IItemProvider)DEContent.dislocator_p2p);
        BoundDislocator.setLinkId(stack, linkID);
        BoundDislocator.setDislocatorId(stack, UUID.randomUUID());
        return stack;
    }

    @Override
    public TargetPos getTargetPos(ItemStack stack, @Nullable World world) {
        if (world instanceof ServerWorld) {
            if (BoundDislocator.isPlayer(stack)) {
                ServerPlayerEntity player;
                UUID playerID = BoundDislocator.getPlayerID(stack);
                MinecraftServer server = world.func_73046_m();
                if (playerID != null && server != null && (player = server.func_184103_al().func_177451_a(playerID)) != null) {
                    return new TargetPos((Entity)player);
                }
            } else {
                DislocatorTarget target = DislocatorSaveData.getLinkTarget(world, stack);
                UUID linkID = BoundDislocator.getLinkId(stack);
                if (target != null && linkID != null) {
                    return target.getTargetPos(world.func_73046_m(), linkID, BoundDislocator.getDislocatorId(stack));
                }
            }
        }
        return null;
    }

    public static void notifyArriving(ItemStack stack, World world, Entity entity) {
        DislocatorTarget target;
        if (world instanceof ServerWorld && (target = DislocatorSaveData.getLinkTarget(world, stack)) != null) {
            target.preTeleport(world.func_73046_m(), entity);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == DEContent.dislocator_p2p_unbound) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.click_to_link").func_240699_a_(TextFormatting.GREEN));
        } else if (stack.func_77973_b() == DEContent.dislocator_player_unbound) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.click_to_link_self").func_240699_a_(TextFormatting.GREEN));
        } else if (BoundDislocator.isPlayer(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.player_link").func_240702_b_(": ").func_240702_b_(ItemNBTHelper.getString((ItemStack)stack, (String)"player_name", (String)"Unknown Player")).func_240699_a_(TextFormatting.BLUE));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("dislocate.draconicevolution.bound.link_id").func_240702_b_(": ").func_240702_b_(String.valueOf(BoundDislocator.getLinkId(stack))).func_240699_a_(TextFormatting.BLUE));
        }
    }

    @Override
    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new PersistentItemEntity(world, location, itemstack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.RARE;
    }
}

