/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.power.IOPStorageModifiable;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.FlightEntity;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public interface IModularArmor
extends IModularItem {
    @Override
    default public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap<Attribute, AttributeModifier> map = IModularItem.super.getAttributeModifiers(slot, stack);
        return map;
    }

    @Override
    default public void addModularItemInformation(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ModuleHost host;
        SpeedData speed;
        IModularItem.super.addModularItemInformation(stack, worldIn, tooltip, flagIn);
        if (DEConfig.armorSpeedLimit != -1.0 && stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).isPresent() && (speed = (host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new)).getModuleData(ModuleTypes.SPEED)) != null && speed.getSpeedMultiplier() > DEConfig.armorSpeedLimit) {
            tooltip.add((ITextComponent)new StringTextComponent("Speed limit on this server is +" + (int)(DEConfig.armorSpeedLimit * 100.0) + "%").func_240699_a_(TextFormatting.RED));
        }
    }

    default public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        LazyOptional power = stack.getCapability(DECapabilities.OP_STORAGE);
        power.ifPresent(storage -> {
            if (storage.getOPStored() < 512L) {
                Vector3d motion = entity.func_213322_ci();
                entity.func_213293_j(motion.field_72450_a * 0.95, motion.field_72448_b > 0.0 ? motion.field_72448_b * 0.95 : motion.field_72448_b, motion.field_72449_c * 0.95);
            } else if (storage instanceof IOPStorageModifiable) {
                int energy = EquipCfg.elytraFlightEnergy;
                if (entity.func_70051_ag()) {
                    double flightSpeed;
                    ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
                    FlightEntity module = host.getEntitiesByType(ModuleTypes.FLIGHT).findAny().orElse(null);
                    double d = flightSpeed = module == null ? 0.0 : module.getElytraBoost();
                    if (flightSpeed > 0.0) {
                        double speed = 1.5 * flightSpeed;
                        double accel = 0.01 * flightSpeed;
                        Vector3d look = entity.func_70040_Z();
                        Vector3d motion = entity.func_213322_ci();
                        entity.func_213317_d(motion.func_72441_c(look.field_72450_a * accel + (look.field_72450_a * speed - motion.field_72450_a) * accel, look.field_72448_b * accel + (look.field_72448_b * speed - motion.field_72448_b) * accel, look.field_72449_c * accel + (look.field_72449_c * speed - motion.field_72449_c) * accel));
                        energy = (int)((double)energy + (double)EquipCfg.getElytraEnergy(module.getModule().getModuleTechLevel()) * flightSpeed);
                    }
                }
                if (!entity.field_70170_p.field_72995_K) {
                    ((IOPStorageModifiable)storage).modifyEnergyStored((long)(-energy));
                }
            }
        });
        return true;
    }

    default public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.MODULE_HOST_CAPABILITY).orElseThrow(IllegalStateException::new);
        FlightEntity flight = host.getEntitiesByType(ModuleTypes.FLIGHT).map(e -> (FlightEntity)e).findAny().orElse(null);
        return flight != null && flight.getElytraEnabled();
    }
}

