/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSoul
extends ItemBCore {
    private static Map<String, Entity> renderEntityMap = new HashMap<String, Entity>();
    private static Map<String, String> entityNameCache = new HashMap<String, String>();
    public static List<String> randomDisplayList = null;
    private static Map<String, ResourceLocation> rlCache = new WeakHashMap<String, ResourceLocation>();

    public MobSoul(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        Direction facing = context.func_196000_l();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        if (player.func_225608_bj_()) {
            Entity entity = this.createEntity(world, stack);
            double sX = (double)(pos.func_177958_n() + facing.func_82601_c()) + 0.5;
            double sY = (double)(pos.func_177956_o() + facing.func_96559_d()) + 0.5;
            double sZ = (double)(pos.func_177952_p() + facing.func_82599_e()) + 0.5;
            if (entity == null) {
                LogHelper.error("Mob Soul bound entity = null");
                return super.func_195939_a(context);
            }
            entity.func_70012_b(sX, sY, sZ, player.field_70177_z, 0.0f);
            if (!world.field_72995_K) {
                CompoundNBT compound = ItemNBTHelper.getCompound((ItemStack)stack);
                if (!compound.func_74764_b("EntityData") && entity instanceof MobEntity) {
                    ((MobEntity)entity).func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(0, 0, 0)), SpawnReason.SPAWN_EGG, null, null);
                }
                world.func_217376_c(entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryUtils.consumeHeldItem((PlayerEntity)player, (ItemStack)stack, (Hand)context.func_221531_n());
                }
            }
        }
        return super.func_195939_a(context);
    }

    public String getEntityString(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"EntityName", (String)"Pig");
    }

    public void setEntity(ResourceLocation entityName, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"EntityName", (String)String.valueOf(entityName));
    }

    @Nullable
    public CompoundNBT getEntityData(ItemStack stack) {
        CompoundNBT compound = ItemNBTHelper.getCompound((ItemStack)stack);
        if (compound.func_74764_b("EntityData")) {
            return compound.func_74775_l("EntityData");
        }
        return null;
    }

    public void setEntityData(CompoundNBT compound, ItemStack stack) {
        compound.func_82580_o("UUID");
        compound.func_82580_o("Motion");
        ItemNBTHelper.getCompound((ItemStack)stack).func_218657_a("EntityData", (INBT)compound);
    }

    public Entity createEntity(World world, ItemStack stack) {
        try {
            Entity entity;
            String eName = this.getEntityString(stack);
            CompoundNBT entityData = this.getEntityData(stack);
            EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(MobSoul.getCachedRegName(eName));
            if (type == null) {
                entity = EntityType.field_200784_X.func_200721_a(world);
            } else {
                entity = type.func_200721_a(world);
                if (entity == null) {
                    return EntityType.field_200784_X.func_200721_a(world);
                }
                if (entityData != null) {
                    entity.func_70020_e(entityData);
                } else {
                    this.loadAdditionalEntityInfo(stack, entity);
                    if (entity instanceof MobEntity) {
                        ((MobEntity)entity).func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(new BlockPos(0, 0, 0)), SpawnReason.SPAWN_EGG, null, null);
                    }
                }
            }
            return entity;
        }
        catch (Throwable e) {
            return EntityType.field_200784_X.func_200721_a(world);
        }
    }

    public ItemStack getSoulFromEntity(Entity entity, boolean saveEntityData) {
        ItemStack soul = new ItemStack((IItemProvider)DEContent.mob_soul);
        String registryName = entity.func_200600_R().getRegistryName().toString();
        ItemNBTHelper.setString((ItemStack)soul, (String)"EntityName", (String)registryName);
        if (saveEntityData) {
            CompoundNBT compound = new CompoundNBT();
            entity.func_189511_e(compound);
            this.setEntityData(compound, soul);
        } else {
            this.saveAditionalEntityInfo(entity, soul);
        }
        return soul;
    }

    public Entity getRenderEntity(ItemStack stack) {
        return this.getRenderEntity(this.getEntityString(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getRenderEntity(String name) {
        if (name.equals("[Random-Display]")) {
            if (randomDisplayList == null) {
                randomDisplayList = new ArrayList<String>();
                SpawnEggItem.field_195987_b.keySet().forEach(type -> randomDisplayList.add(type.getRegistryName().toString()));
            }
            if (randomDisplayList.size() > 0) {
                name = randomDisplayList.get(ClientEventHandler.elapsedTicks / 20 % randomDisplayList.size());
            }
        }
        if (!renderEntityMap.containsKey(name)) {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            try {
                EntityType type2 = (EntityType)ForgeRegistries.ENTITIES.getValue(MobSoul.getCachedRegName(name));
                if (type2 != null) {
                    entity = type2.func_200721_a((World)world);
                    if (entity == null) {
                        entity = EntityType.field_200784_X.func_200721_a((World)world);
                    }
                } else {
                    entity = EntityType.field_200784_X.func_200721_a((World)world);
                }
            }
            catch (Throwable e) {
                entity = EntityType.field_200784_X.func_200721_a((World)world);
            }
            renderEntityMap.put(name, entity);
        }
        return renderEntityMap.get(name);
    }

    private void saveAditionalEntityInfo(Entity entity, ItemStack stack) {
    }

    private void loadAdditionalEntityInfo(ItemStack stack, Entity entity) {
    }

    public static ResourceLocation getCachedRegName(String name) {
        return rlCache.computeIfAbsent(name, ResourceLocation::new);
    }
}

