/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.api.energy.ICrystalLink;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BinderHandler {
    public static Map<AxisAlignedBB, CCModel> modelCache = new HashMap<AxisAlignedBB, CCModel>();

    public static boolean onBinderUse(PlayerEntity player, Hand hand, World world, BlockPos blockClicked, @Nonnull ItemStack binder, Direction sideClicked) {
        TileEntity tile = world.func_175625_s(blockClicked);
        boolean isBound = BinderHandler.isBound(binder);
        if (tile instanceof ICrystalLink && player.func_225608_bj_()) {
            BinderHandler.bind(binder, blockClicked);
            if (world.field_72995_K) {
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.pos_saved_to_tool").func_240699_a_(TextFormatting.GREEN), (int)99);
                player.func_184609_a(hand);
            }
            return true;
        }
        if (tile instanceof ICrystalLink && !isBound) {
            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.tool_not_bound").func_240699_a_(TextFormatting.RED), (int)99);
            return true;
        }
        if (isBound) {
            BlockPos boundLinkable = BinderHandler.getBound(binder);
            if (boundLinkable.equals((Object)blockClicked)) {
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.link_to_self").func_240699_a_(TextFormatting.RED), (int)99);
                return true;
            }
            TileEntity boundTile = world.func_175625_s(boundLinkable);
            if (boundTile instanceof ICrystalLink) {
                if (((ICrystalLink)boundTile).binderUsed(player, blockClicked, sideClicked)) {
                    player.func_184609_a(hand);
                }
            } else {
                ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.bound_to_invalid").func_240699_a_(TextFormatting.RED), (int)99);
            }
            return true;
        }
        return false;
    }

    private static boolean isBound(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("draconicevolution:binder", 11);
    }

    private static void bind(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.getCompound((ItemStack)stack).func_74783_a("draconicevolution:binder", new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
    }

    private static BlockPos getBound(ItemStack stack) {
        int[] intArray = stack.func_77978_p().func_74759_k("draconicevolution:binder");
        return new BlockPos(intArray[0], intArray[1], intArray[2]);
    }

    public static boolean clearBinder(PlayerEntity player, @Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("draconicevolution:binder")) {
            stack.func_77978_p().func_82580_o("draconicevolution:binder");
            ChatHelper.sendIndexed((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("gui.draconicevolution.energy_net.pos_cleared"), (int)99);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWorldOverlay(ClientPlayerEntity player, MatrixStack matrixStack, World world, ItemStack stack, Minecraft mc, float partialTicks) {
        if (!BinderHandler.isBound(stack)) {
            return;
        }
        Matrix4 mat = new Matrix4(matrixStack);
        BlockPos pos = BinderHandler.getBound(stack);
        boolean valid = world.func_175625_s(pos) instanceof ICrystalLink;
        ActiveRenderInfo renderInfo = mc.field_71460_t.func_215316_n();
        double projectedX = renderInfo.func_216785_c().field_72450_a;
        double projectedY = renderInfo.func_216785_c().field_72448_b;
        double projectedZ = renderInfo.func_216785_c().field_72449_c;
        BlockState state = world.func_180495_p(pos);
        VoxelShape shape = state.func_196954_c((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            shape = VoxelShapes.func_197868_b();
        }
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Cuboid6 cuboid6 = new Cuboid6(shape.func_197752_a());
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.disableDepthTest();
        CCRenderState ccrs = CCRenderState.instance();
        mat.translate((double)pos.func_177958_n() - projectedX, (double)pos.func_177956_o() - projectedY, (double)pos.func_177952_p() - projectedZ);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(GuiElement.transColourType), (Transformation)mat);
        RenderUtils.bufferCuboidSolid((IVertexBuilder)builder, (Cuboid6)cuboid6, (float)(valid ? 0.0f : 1.0f), (float)(valid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        ccrs.draw();
        builder = new TransformingVertexBuilder(getter.getBuffer(RenderType.func_228659_m_()), (Transformation)mat);
        RenderUtils.bufferCuboidOutline((IVertexBuilder)builder, (Cuboid6)cuboid6, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        ccrs.draw();
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
    }

    private static CCModel modelForAABB(AxisAlignedBB aabb) {
        if (!modelCache.containsKey(aabb)) {
            modelCache.put(aabb, CCModel.newModel((int)7, (int)24).generateBlock(0, new Cuboid6(aabb)));
        }
        return modelCache.get(aabb);
    }
}

