/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.lib.Serializers;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkHolder;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Deprecated
public class DraconicProjectileEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(DraconicProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> ARROW_PROJECTILE = EntityDataManager.func_187226_a(DraconicProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> NO_DRAG = EntityDataManager.func_187226_a(DraconicProjectileEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> EFFECT_COLOR = EntityDataManager.func_187226_a(DraconicProjectileEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<Module<?>>> DAMAGE_MODIFIER = EntityDataManager.func_187226_a(DraconicProjectileEntity.class, Serializers.OPT_MODULE_SERIALIZER);
    private static final IDamageModifier defaultStaffModifier = new DefaultStaffDmgMod();
    private Potion potion = Potions.field_185229_a;
    private final Set<EffectInstance> customPotionEffects = Sets.newHashSet();
    private boolean fixedColor;
    private int flightTime = 0;
    private int maxFlightTime = -1;
    private int explosivePower = 0;
    private boolean explodeBlocks = false;
    private float projectileBaseDamage = 0.0f;
    private float secondaryChange = 0.0f;
    private boolean useDefaultStaffModifier = false;
    private boolean pseudoInstantTravel = false;

    public DraconicProjectileEntity(EntityType<? extends DraconicProjectileEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DraconicProjectileEntity(World worldIn, double x, double y, double z) {
        super(DEContent.draconicArrow, x, y, z, worldIn);
    }

    public DraconicProjectileEntity(World worldIn, LivingEntity shooter) {
        super(DEContent.draconicArrow, shooter, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
        this.field_70180_af.func_187214_a(ARROW_PROJECTILE, (Object)true);
        this.field_70180_af.func_187214_a(NO_DRAG, (Object)false);
        this.field_70180_af.func_187214_a(EFFECT_COLOR, (Object)-1);
        this.field_70180_af.func_187214_a(DAMAGE_MODIFIER, Optional.empty());
    }

    public void setArrowProjectile(boolean isArrowProjectile) {
        this.field_70180_af.func_187227_b(ARROW_PROJECTILE, (Object)isArrowProjectile);
    }

    public boolean isArrowProjectile() {
        return (Boolean)this.field_70180_af.func_187225_a(ARROW_PROJECTILE);
    }

    public void setDamageModifier(Module<?> damageModule) {
        if (damageModule != null && damageModule.getData() instanceof DamageModData) {
            this.field_70180_af.func_187227_b(DAMAGE_MODIFIER, Optional.of(damageModule));
        } else {
            this.field_70180_af.func_187227_b(DAMAGE_MODIFIER, Optional.empty());
        }
    }

    @Nullable
    public Module<DamageModData> getDamageModifier() {
        Optional opt = (Optional)this.field_70180_af.func_187225_a(DAMAGE_MODIFIER);
        if (opt.isPresent() && ((Module)opt.get()).getData() instanceof DamageModData) {
            return (Module)opt.get();
        }
        return null;
    }

    public void setNoDrag(boolean hasNoDrag) {
        this.field_70180_af.func_187227_b(NO_DRAG, (Object)hasNoDrag);
    }

    public boolean hasNoDrag() {
        return (Boolean)this.field_70180_af.func_187225_a(NO_DRAG);
    }

    public void setMaxFlightTime(int maxFlightTime) {
        this.maxFlightTime = maxFlightTime;
    }

    public void setExplosivePower(int explosivePower, boolean damageBlocks) {
        this.explosivePower = explosivePower;
        this.explodeBlocks = damageBlocks;
    }

    public void setEffectColour(int colour) {
        this.field_70180_af.func_187227_b(EFFECT_COLOR, (Object)colour);
    }

    public int getEffectColor() {
        return (Integer)this.field_70180_af.func_187225_a(EFFECT_COLOR);
    }

    public void useDefaultStaffModifier() {
        this.useDefaultStaffModifier = true;
    }

    public void setPseudoInstantTravel(boolean pseudoInstantTravel) {
        this.pseudoInstantTravel = pseudoInstantTravel;
    }

    public void setProjectileBaseDamage(float projectileBaseDamage) {
        this.projectileBaseDamage = projectileBaseDamage;
    }

    protected boolean activateDamageEffect(@Nullable RayTraceResult traceResult) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity owner = this.func_234616_v_();
        Module<DamageModData> damageMod = this.getDamageModifier();
        Vector3d pos = this.func_213303_ch();
        if (traceResult != null) {
            if (traceResult instanceof EntityRayTraceResult) {
                pos = traceResult.func_216347_e();
            } else {
                Vector3d hitPos = traceResult.func_216347_e();
                if (hitPos.func_72438_d(pos) > 1.0) {
                    Vector3d dirVec = pos.func_178788_d(hitPos).func_72432_b();
                    pos = hitPos.func_178787_e(dirVec);
                }
            }
        }
        boolean disableDefault = false;
        if (damageMod != null || this.useDefaultStaffModifier) {
            IDamageModifier modifier = this.useDefaultStaffModifier ? defaultStaffModifier : damageMod.getData().getModifier();
            modifier.doDamageAndEffects(this.field_70170_p, pos, traceResult, owner instanceof LivingEntity ? (LivingEntity)owner : null, this.projectileBaseDamage, this.secondaryChange, true);
            this.setDamageModifier(null);
            disableDefault = true;
        } else if (this.explosivePower > 0) {
            if (owner instanceof LivingEntity) {
                this.field_70170_p.func_230546_a_(owner, DamageSource.func_188405_b((LivingEntity)((LivingEntity)owner)), null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (float)this.explosivePower, false, this.explodeBlocks ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            } else {
                this.field_70170_p.func_217398_a((Entity)this, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (float)this.explosivePower, false, this.explodeBlocks ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            }
            this.explosivePower = 0;
            disableDefault = true;
        }
        if (!this.isArrowProjectile()) {
            this.func_174812_G();
        }
        return disableDefault;
    }

    public void func_234612_a_(Entity p_234612_1_, float playerXRot, float playerYRot, float someZeroOffset, float power, float inaccuracy) {
        if (power >= 100.0f) {
            this.setPseudoInstantTravel(true);
        }
        super.func_234612_a_(p_234612_1_, playerXRot, playerYRot, someZeroOffset, power, inaccuracy);
    }

    protected void func_213868_a(EntityRayTraceResult entityRayTraceResult) {
        if (this.activateDamageEffect((RayTraceResult)entityRayTraceResult)) {
            return;
        }
        super.func_213868_a(entityRayTraceResult);
    }

    protected void func_230299_a_(BlockRayTraceResult blockRayTraceResult) {
        if (this.activateDamageEffect((RayTraceResult)blockRayTraceResult)) {
            return;
        }
        super.func_230299_a_(blockRayTraceResult);
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_185167_i) {
            int i;
            this.potion = PotionUtils.func_185191_c((ItemStack)stack);
            List collection = PotionUtils.func_185190_b((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (EffectInstance effectinstance : collection) {
                    this.customPotionEffects.add(new EffectInstance(effectinstance));
                }
            }
            if ((i = DraconicProjectileEntity.getCustomColor(stack)) == -1) {
                this.refreshColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.func_77973_b() == Items.field_151032_g) {
            this.potion = Potions.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack colour) {
        CompoundNBT compoundnbt = colour.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99) ? compoundnbt.func_74762_e("CustomPotionColor") : -1;
    }

    private void refreshColor() {
        this.fixedColor = false;
        if (this.potion == Potions.field_185229_a && this.customPotionEffects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.customPotionEffects)));
        }
    }

    public void addEffect(EffectInstance effect) {
        this.customPotionEffects.add(effect);
        this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.customPotionEffects)));
    }

    public void func_70071_h_() {
        boolean forceActivation;
        boolean bl = forceActivation = this.pseudoInstantTravel && !Utils.isAreaLoaded((World)this.field_70170_p, (BlockPos)new BlockPos(this.func_213303_ch().func_178787_e(this.func_213322_ci().func_216372_d(1.1, 1.1, 1.1))), (ChunkHolder.LocationType)ChunkHolder.LocationType.ENTITY_TICKING);
        if (this.hasNoDrag()) {
            Vector3d velocity = this.func_213322_ci();
            super.func_70071_h_();
            if (!this.func_189652_ae()) {
                velocity = velocity.func_178786_a(0.0, 0.05, 0.0);
            }
            this.func_213317_d(velocity);
        } else {
            super.func_70071_h_();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.customPotionEffects.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)0);
            this.potion = Potions.field_185229_a;
            this.customPotionEffects.clear();
            this.field_70180_af.func_187227_b(COLOR, (Object)-1);
        }
        if (!this.field_70254_i) {
            if (this.maxFlightTime > 0) {
                ++this.flightTime;
                if (this.flightTime >= this.maxFlightTime || forceActivation) {
                    this.activateDamageEffect(null);
                }
            }
        } else {
            this.flightTime = 0;
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    private void setFixedColor(int colour) {
        this.fixedColor = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)colour);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.potion != Potions.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.customPotionEffects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
        if (this.maxFlightTime != -1) {
            compound.func_74768_a("MaxFlightTime", this.maxFlightTime);
            compound.func_74768_a("FlightTime", this.flightTime);
        }
        if (this.explosivePower > 0) {
            compound.func_74777_a("ExplosivePower", (short)this.explosivePower);
            compound.func_74757_a("ExplodeBlocks", this.explodeBlocks);
        }
        compound.func_74757_a("PseudoInstantTravel", this.pseudoInstantTravel);
        compound.func_74776_a("ProjectileBaseDamage", this.projectileBaseDamage);
        compound.func_74776_a("SecondaryChange", this.secondaryChange);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.potion = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        for (EffectInstance effectinstance : PotionUtils.func_185192_b((CompoundNBT)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setFixedColor(compound.func_74762_e("Color"));
        } else {
            this.refreshColor();
        }
        if (compound.func_74764_b("MaxFlightTime")) {
            this.maxFlightTime = compound.func_74762_e("MaxFlightTime");
            this.flightTime = compound.func_74762_e("FlightTime");
        }
        if (compound.func_74764_b("ExplosivePower")) {
            this.explosivePower = compound.func_74765_d("ExplosivePower");
            this.explodeBlocks = compound.func_74767_n("ExplodeBlocks");
        }
        this.pseudoInstantTravel = compound.func_74767_n("PseudoInstantTravel");
        this.projectileBaseDamage = compound.func_74760_g("ProjectileBaseDamage");
        this.secondaryChange = compound.func_74760_g("SecondaryChange");
    }

    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        for (EffectInstance effectinstance : this.potion.func_185170_a()) {
            living.func_195064_c(new EffectInstance(effectinstance.func_188419_a(), Math.max(effectinstance.func_76459_b() / 8, 1), effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (EffectInstance effectinstance1 : this.customPotionEffects) {
                living.func_195064_c(effectinstance1);
            }
        }
    }

    protected ItemStack func_184550_j() {
        if (this.customPotionEffects.isEmpty() && this.potion == Potions.field_185229_a) {
            return new ItemStack((IItemProvider)Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack((IItemProvider)Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.customPotionEffects);
        if (this.fixedColor) {
            itemstack.func_196082_o().func_74768_a("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public IPacket<?> func_213297_N() {
        return BCoreNetwork.getEntitySpawnPacket((Entity)this);
    }
}

