/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.worldentity.ITickableWorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.api.damage.IDraconicDamage;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianSpawnState;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ShieldedServerBossInfo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import org.apache.logging.log4j.Logger;

public class GuardianFightManager
extends WorldEntity
implements ITickableWorldEntity {
    private static final Logger LOGGER = DraconicEvolution.LOGGER;
    public static final int CRYSTAL_DIST_FROM_CENTER = 90;
    public static final int CRYSTAL_HEIGHT_FROM_ORIGIN = 40;
    public static final float PROJECTILE_POWER = 15.0f;
    public static final float CHARGE_DAMAGE = 150.0f;
    public static final float COVER_FIRE_POWER = 15.0f;
    private Predicate<Entity> validPlayer;
    private final ShieldedServerBossInfo bossInfo = (ShieldedServerBossInfo)new ShieldedServerBossInfo((ITextComponent)new TranslationTextComponent("entity.draconicevolution.draconic_guardian"), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private int ticksSinceGuardianSeen;
    private int aliveCrystals;
    private int ticksSinceCrystalsScanned;
    private int ticksSinceLastPlayerScan;
    private boolean guardianKilled;
    private UUID guardianUniqueId;
    private BlockPos arenaOrigin;
    public GuardianSpawnState respawnState;
    private int respawnStateTicks;
    private List<BlockPos> crystalsPosCache;
    private List<BlockPos> crystalSpawnList;

    public GuardianFightManager() {
        super(DEContent.guardianManagerType);
    }

    public GuardianFightManager(BlockPos origin) {
        super(DEContent.guardianManagerType);
        this.arenaOrigin = origin;
        this.validPlayer = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)origin.func_177958_n(), (double)origin.func_177956_o(), (double)origin.func_177952_p(), (double)250.0));
        this.respawnState = GuardianSpawnState.START_WAIT_FOR_PLAYER;
        this.bossInfo.func_186735_a(0.0f);
        this.bossInfo.setShieldPower(0.0f);
    }

    public void tick() {
        ServerWorld world = (ServerWorld)this.world;
        this.bossInfo.func_186758_d(!this.guardianKilled && this.respawnState != GuardianSpawnState.START_WAIT_FOR_PLAYER);
        if (++this.ticksSinceLastPlayerScan >= 20) {
            this.updatePlayers();
            this.ticksSinceLastPlayerScan = 0;
        }
        if (!this.bossInfo.func_186757_c().isEmpty()) {
            world.func_72863_F().func_217228_a(TicketType.field_219489_b, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
            boolean areaLoaded = this.isFightAreaLoaded();
            if (this.respawnState != null) {
                this.respawnState.process(world, this, null, this.respawnStateTicks++, this.arenaOrigin);
            }
            if (!this.guardianKilled && this.respawnState == null) {
                if ((this.guardianUniqueId == null || ++this.ticksSinceGuardianSeen >= 1200) && areaLoaded) {
                    this.findOrCreateGuardian();
                    this.ticksSinceGuardianSeen = 0;
                }
                if (++this.ticksSinceCrystalsScanned >= 100 && areaLoaded) {
                    this.findAliveCrystals();
                    this.ticksSinceCrystalsScanned = 0;
                }
            }
        } else {
            world.func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
        }
    }

    private void findOrCreateGuardian() {
        ServerWorld world = (ServerWorld)this.world;
        List list = world.getEntities().filter(e -> e instanceof DraconicGuardianEntity).map(e -> (DraconicGuardianEntity)((Object)e)).collect(Collectors.toList());
        if (list.isEmpty()) {
            LOGGER.debug("Haven't seen the guardian, respawning it");
            this.createNewGuardian();
        } else {
            LOGGER.debug("Haven't seen our guardian, but found another one to use.");
            this.guardianUniqueId = ((DraconicGuardianEntity)((Object)list.get(0))).func_110124_au();
        }
    }

    protected void setRespawnState(GuardianSpawnState state) {
        if (this.respawnState == null) {
            throw new IllegalStateException("Guardian respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.respawnStateTicks = 0;
        if (state == GuardianSpawnState.END) {
            this.respawnState = null;
            this.guardianKilled = false;
            this.findAliveCrystals();
            DraconicGuardianEntity guardian = this.createNewGuardian();
            for (ServerPlayerEntity serverplayerentity : this.bossInfo.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(serverplayerentity, (Entity)guardian);
            }
        } else {
            this.respawnState = state;
        }
    }

    private boolean isFightAreaLoaded() {
        for (int x = -8; x <= 8; ++x) {
            for (int z = 8; z <= 8; ++z) {
                ChunkPos pos = new ChunkPos(this.arenaOrigin);
                IChunk ichunk = this.world.func_217353_a(pos.field_77276_a + x, pos.field_77275_b + z, ChunkStatus.field_222617_m, false);
                if (!(ichunk instanceof Chunk)) {
                    return false;
                }
                ChunkHolder.LocationType locationType = ((Chunk)ichunk).func_217321_u();
                if (locationType.func_219065_a(ChunkHolder.LocationType.TICKING)) continue;
                return false;
            }
        }
        return true;
    }

    private void updatePlayers() {
        ServerWorld world = (ServerWorld)this.world;
        HashSet validPlayers = Sets.newHashSet();
        for (ServerPlayerEntity player : world.func_217490_a(this.validPlayer)) {
            this.bossInfo.func_186760_a(player);
            validPlayers.add(player);
        }
        HashSet invalidPlayers = Sets.newHashSet((Iterable)this.bossInfo.func_186757_c());
        invalidPlayers.removeAll(validPlayers);
        for (ServerPlayerEntity player : invalidPlayers) {
            this.bossInfo.func_186761_b(player);
        }
    }

    public void processDragonDeath(DraconicGuardianEntity guardian) {
        this.bossInfo.func_186735_a(0.0f);
        this.bossInfo.setShieldPower(0.0f);
        this.bossInfo.func_186758_d(false);
        this.guardianKilled = true;
        TileEntity tile = this.world.func_175625_s(this.arenaOrigin);
        if (tile instanceof TileChaosCrystal) {
            ((TileChaosCrystal)tile).setDefeated();
        }
        GuardianFightManager manager = guardian.getFightManager();
        ItemEntity item = (ItemEntity)EntityType.field_200765_E.func_200721_a(guardian.field_70170_p);
        if (manager != null && item != null) {
            item.func_92058_a(new ItemStack((IItemProvider)DEContent.dragon_heart));
            BlockPos podiumPos = manager.getArenaOrigin().func_177981_b(20);
            item.func_70012_b((double)podiumPos.func_177958_n() + 0.5, (double)podiumPos.func_177956_o(), (double)podiumPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            item.func_213293_j(0.0, 0.0, 0.0);
            item.field_70292_b = -32767;
            item.func_184224_h(true);
            item.func_189654_d(true);
            guardian.field_70170_p.func_217376_c((Entity)item);
        }
        this.cleanUpAndDispose();
    }

    private DraconicGuardianEntity createNewGuardian() {
        ServerWorld world = (ServerWorld)this.world;
        world.func_175726_f(this.guardianSpawnPos());
        DraconicGuardianEntity guardian = (DraconicGuardianEntity)DEContent.draconicGuardian.func_200721_a((World)world);
        assert (guardian != null);
        guardian.getPhaseManager().setPhase(PhaseType.START);
        guardian.func_70012_b(this.guardianSpawnPos().func_177958_n(), this.guardianSpawnPos().func_177956_o(), this.guardianSpawnPos().func_177952_p(), this.world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        guardian.setFightManager(this);
        guardian.setArenaOrigin(this.arenaOrigin);
        world.func_217376_c((Entity)guardian);
        this.guardianUniqueId = guardian.func_110124_au();
        return guardian;
    }

    public void guardianUpdate(DraconicGuardianEntity guardian) {
        if (guardian.func_110124_au().equals(this.guardianUniqueId)) {
            this.bossInfo.func_186735_a(guardian.func_110143_aJ() / guardian.func_110138_aP());
            this.bossInfo.setShieldPower(guardian.getShieldPower() / (float)DEConfig.guardianShield);
            this.bossInfo.setImmune(guardian.getPhaseManager().getCurrentPhase().isInvulnerable());
            this.bossInfo.func_186745_a(guardian.getShieldPower() > 0.0f ? BossInfo.Color.PURPLE : BossInfo.Color.RED);
            this.ticksSinceGuardianSeen = 0;
            if (!this.arenaOrigin.equals((Object)guardian.getArenaOrigin())) {
                guardian.setArenaOrigin(this.arenaOrigin);
                guardian.initPathPoints(true);
            }
            if (guardian.func_145818_k_()) {
                this.bossInfo.func_186739_a(guardian.func_145748_c_());
            }
        }
    }

    private void cleanUpAndDispose() {
        ((ServerWorld)this.world).func_72863_F().func_217222_b(TicketType.field_219489_b, new ChunkPos(this.arenaOrigin), 12, (Object)Unit.INSTANCE);
        this.bossInfo.func_201360_b();
        this.removeEntity();
    }

    public UUID getGuardianUniqueId() {
        return this.guardianUniqueId;
    }

    public Collection<ServerPlayerEntity> getTrackedPlayers() {
        return this.bossInfo.func_186757_c();
    }

    private void findAliveCrystals() {
        this.ticksSinceCrystalsScanned = 0;
        this.aliveCrystals = 0;
        for (BlockPos pos : this.getCrystalPositions()) {
            List list = this.world.func_217357_a(GuardianCrystalEntity.class, new AxisAlignedBB(pos.func_177982_a(-3, -3, -3), pos.func_177982_a(4, 4, 4)));
            for (GuardianCrystalEntity crystal : list) {
                if (!crystal.func_70089_S()) continue;
                if (crystal.getManagerId() == null || !crystal.getManagerId().equals(this.getUniqueID())) {
                    crystal.setManagerId(this.getUniqueID());
                }
                ++this.aliveCrystals;
            }
        }
        this.bossInfo.setCrystals(this.getNumAliveCrystals());
        LOGGER.debug("Found {} end crystals still alive", (Object)this.aliveCrystals);
    }

    public void crystalSpawned() {
        ++this.aliveCrystals;
        this.bossInfo.setCrystals(this.getNumAliveCrystals());
    }

    public int getNumAliveCrystals() {
        return this.aliveCrystals;
    }

    public void onCrystalAttacked(GuardianCrystalEntity crystal, DamageSource dmgSrc, float damage, boolean destroyed) {
        Entity entity;
        ServerWorld world = (ServerWorld)this.world;
        if (destroyed) {
            this.findAliveCrystals();
        }
        if ((entity = world.func_217461_a(this.guardianUniqueId)) instanceof DraconicGuardianEntity) {
            ((DraconicGuardianEntity)entity).onCrystalAttacked(crystal, crystal.func_233580_cy_(), dmgSrc, damage, destroyed);
        }
    }

    public float getCrystalDamageModifier(GuardianCrystalEntity crystal, DamageSource dmgSrc) {
        if (dmgSrc.func_76346_g() instanceof DraconicGuardianEntity) {
            crystal.destabilize();
            return 0.1f;
        }
        if (IDraconicDamage.getDamageLevel(dmgSrc) == TechLevel.CHAOTIC && DEConfig.chaoticBypassCrystalShield) {
            crystal.destabilize();
            return 1.0f;
        }
        return crystal.getUnstableTime() > 0 ? 1.0f : 0.0f;
    }

    public boolean onGuardianAttacked(DraconicGuardianEntity guardian, DamageSource source, float damage) {
        return this.getNumAliveCrystals() == 0;
    }

    public void resetCrystals() {
        for (BlockPos pos : this.getCrystalPositions()) {
            for (GuardianCrystalEntity endercrystalentity : this.world.func_217357_a(GuardianCrystalEntity.class, new AxisAlignedBB(pos.func_177982_a(-3, -3, -3), pos.func_177982_a(4, 4, 4)))) {
                endercrystalentity.func_184224_h(false);
                endercrystalentity.setBeamTarget(null);
            }
        }
    }

    public List<GuardianCrystalEntity> getCrystals() {
        ArrayList<GuardianCrystalEntity> list = new ArrayList<GuardianCrystalEntity>();
        for (BlockPos pos : this.getCrystalPositions()) {
            list.addAll(this.world.func_217357_a(GuardianCrystalEntity.class, new AxisAlignedBB(pos.func_177982_a(-3, -3, -3), pos.func_177982_a(4, 4, 4))));
        }
        return list;
    }

    public List<BlockPos> getCrystalPositions() {
        if (this.crystalsPosCache == null) {
            this.crystalsPosCache = new ArrayList<BlockPos>();
            for (int i = 0; i < 14; ++i) {
                double rotation = (double)i * 0.45;
                int sX = this.arenaOrigin.func_177958_n() + (int)(Math.sin(rotation) * 90.0);
                int sZ = this.arenaOrigin.func_177952_p() + (int)(Math.cos(rotation) * 90.0);
                this.crystalsPosCache.add(new BlockPos(sX, this.arenaOrigin.func_177956_o() + 40, sZ));
            }
        }
        return this.crystalsPosCache;
    }

    public BlockPos getNextCrystalPos(boolean initial) {
        if (initial) {
            this.crystalSpawnList = new ArrayList<BlockPos>(this.getCrystalPositions());
        }
        if (this.crystalSpawnList.isEmpty()) {
            return null;
        }
        return this.crystalSpawnList.remove(0);
    }

    public BlockPos guardianSpawnPos() {
        return this.arenaOrigin.func_177982_a(0, 80, 0);
    }

    public BlockPos getArenaOrigin() {
        return this.arenaOrigin;
    }

    public void write(CompoundNBT nbt) {
        super.write(nbt);
        if (this.guardianUniqueId != null) {
            nbt.func_186854_a("guardian", this.guardianUniqueId);
        }
        nbt.func_74757_a("guardian_killed", this.guardianKilled);
        nbt.func_218657_a("arena_origin", (INBT)NBTUtil.func_186859_a((BlockPos)this.arenaOrigin));
        if (this.respawnState != null) {
            nbt.func_74757_a("respawning", true);
        }
    }

    public void read(CompoundNBT nbt) {
        super.read(nbt);
        if (nbt.func_186855_b("guardian")) {
            this.guardianUniqueId = nbt.func_186857_a("guardian");
        }
        this.guardianKilled = nbt.func_74767_n("guardian_killed");
        this.arenaOrigin = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("arena_origin"));
        this.validPlayer = EntityPredicates.field_94557_a.and(EntityPredicates.func_188443_a((double)this.arenaOrigin.func_177958_n(), (double)this.arenaOrigin.func_177956_o(), (double)this.arenaOrigin.func_177952_p(), (double)192.0));
        if (nbt.func_74767_n("respawning")) {
            this.respawnState = GuardianSpawnState.START_WAIT_FOR_PLAYER;
        }
    }
}

