/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class GuardianCrystalEntity
extends Entity {
    private static final DataParameter<Optional<BlockPos>> BEAM_TARGET = EntityDataManager.func_187226_a(GuardianCrystalEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> SHOW_BOTTOM = EntityDataManager.func_187226_a(GuardianCrystalEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SHIELD_POWER = EntityDataManager.func_187226_a(GuardianCrystalEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> BEAM_POWER = EntityDataManager.func_187226_a(GuardianCrystalEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> UNSTABLE_TIME = EntityDataManager.func_187226_a(GuardianCrystalEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private UUID managerId;
    public int innerRotation;
    private int beamChargeAnim = 0;

    public GuardianCrystalEntity(EntityType<?> type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.innerRotation = this.field_70146_Z.nextInt(100000);
    }

    public GuardianCrystalEntity(World worldIn, double x, double y, double z, UUID managerId) {
        this(DEContent.guardianCrystal, worldIn);
        this.managerId = managerId;
        this.func_70107_b(x, y, z);
    }

    public UUID getManagerId() {
        return this.managerId;
    }

    public void setUnstableTime(int unstableTime) {
        this.field_70180_af.func_187227_b(UNSTABLE_TIME, (Object)unstableTime);
    }

    public int getUnstableTime() {
        return (Integer)this.field_70180_af.func_187225_a(UNSTABLE_TIME);
    }

    public float getShieldPower() {
        return ((Float)this.field_70180_af.func_187225_a(SHIELD_POWER)).floatValue();
    }

    public void setShieldPower(float shieldPower) {
        this.field_70180_af.func_187227_b(SHIELD_POWER, (Object)Float.valueOf(shieldPower));
    }

    public void setManagerId(UUID managerId) {
        this.managerId = managerId;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(BEAM_TARGET, Optional.empty());
        this.func_184212_Q().func_187214_a(SHOW_BOTTOM, (Object)true);
        this.func_184212_Q().func_187214_a(SHIELD_POWER, (Object)Float.valueOf(Math.max(20.0f, (float)DEConfig.guardianCrystalShield)));
        this.func_184212_Q().func_187214_a(UNSTABLE_TIME, (Object)0);
        this.func_184212_Q().func_187214_a(BEAM_POWER, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        ++this.innerRotation;
        if (this.field_70170_p instanceof ServerWorld) {
            GuardianFightManager manager;
            BlockPos blockpos = this.func_233580_cy_();
            if (this.getManagerId() != null && this.field_70170_p.func_180495_p(blockpos).func_196958_f()) {
                this.field_70170_p.func_175656_a(blockpos, AbstractFireBlock.func_235326_a_((IBlockReader)this.field_70170_p, (BlockPos)blockpos));
            }
            if ((manager = this.getManager()) != null) {
                if (this.getUnstableTime() > 0) {
                    this.setBeamTarget(null);
                    this.setUnstableTime(this.getUnstableTime() - 1);
                    if (this.getUnstableTime() > 0) {
                        for (int i = 0; i < 3; ++i) {
                            BCoreNetwork.sendParticle((World)this.field_70170_p, (IParticleData)ParticleTypes.field_197629_v, (Vector3)Vector3.fromEntity((Entity)this), (Vector3)new Vector3((double)this.field_70146_Z.nextFloat(), 0.5 + (double)(this.field_70146_Z.nextFloat() / 2.0f), (double)this.field_70146_Z.nextFloat()).subtract(0.5).multiply(1.5), (boolean)true);
                        }
                        if (this.field_70146_Z.nextInt(3) == 0) {
                            this.setBeamTarget(manager.getArenaOrigin());
                            BCoreNetwork.sendSound((World)this.field_70170_p, (Entity)this, (SoundEvent)DESounds.crystalUnstable, (SoundCategory)SoundCategory.HOSTILE, (float)6.0f, (float)(0.9f + this.field_70146_Z.nextFloat() * 0.2f), (boolean)false);
                        }
                    } else {
                        BCoreNetwork.sendSound((World)this.field_70170_p, (Entity)this, (SoundEvent)DESounds.crystalRestore, (SoundCategory)SoundCategory.HOSTILE, (float)8.0f, (float)(0.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f), (boolean)false);
                    }
                } else if (this.getShieldPower() < (float)DEConfig.guardianCrystalShield) {
                    this.setShieldPower(Math.min((float)DEConfig.guardianCrystalShield, this.getShieldPower() + (float)DEConfig.guardianCrystalShield / 1200.0f));
                    this.playChargeAnimation();
                } else if (this.beamChargeAnim <= 0 && manager.respawnState == null) {
                    this.setBeamTarget(null);
                }
                if (this.beamChargeAnim > 0) {
                    this.setBeamPower(MathHelper.func_76126_a((float)((float)this.beamChargeAnim / 20.0f * (float)Math.PI)));
                    --this.beamChargeAnim;
                    if (this.beamChargeAnim <= 0) {
                        this.beamChargeAnim = 0;
                        this.setBeamTarget(null);
                        this.setBeamPower(1.0f);
                    }
                }
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.getBeamTarget() != null) {
            compound.func_218657_a("BeamTarget", (INBT)NBTUtil.func_186859_a((BlockPos)this.getBeamTarget()));
        }
        compound.func_74757_a("ShowBottom", this.shouldShowBottom());
        compound.func_186854_a("manager_id", this.managerId);
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("BeamTarget", 10)) {
            this.setBeamTarget(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("BeamTarget")));
        }
        if (compound.func_150297_b("ShowBottom", 1)) {
            this.setShowBottom(compound.func_74767_n("ShowBottom"));
        }
        if (compound.func_74764_b("manager_id")) {
            this.managerId = compound.func_186857_a("manager_id");
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            float newPower;
            GuardianFightManager manager = this.getManager();
            float shield = this.getShieldPower() / (float)DEConfig.guardianCrystalShield;
            if (shield > 0.0f) {
                BCoreNetwork.sendSound((World)this.field_70170_p, (Entity)this, (SoundEvent)DESounds.shieldStrike, (SoundCategory)SoundCategory.HOSTILE, (float)6.0f, (float)(0.5f + shield), (boolean)false);
            }
            if (manager != null && shield > 0.0f) {
                float modifier = manager.getCrystalDamageModifier(this, source);
                if (modifier == 0.0f) {
                    this.playChargeAnimation();
                    return false;
                }
                amount *= modifier;
            }
            if (shield > 0.0f && (newPower = (float)((int)(this.getShieldPower() - amount))) > 0.0f) {
                this.setShieldPower(newPower);
                this.onCrystalAttacked(source, amount, false);
                return true;
            }
            this.func_70106_y();
            if (!source.func_94541_c()) {
                this.field_70170_p.func_217385_a((Entity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10.0f, Explosion.Mode.DESTROY);
            }
            this.onCrystalAttacked(source, amount, true);
        }
        return true;
    }

    private void playChargeAnimation() {
        GuardianFightManager manager = this.getManager();
        if (this.beamChargeAnim == 0 && manager != null) {
            BCoreNetwork.sendSound((World)this.field_70170_p, (Entity)this, (SoundEvent)DESounds.crystalBeam, (SoundCategory)SoundCategory.HOSTILE, (float)6.0f, (float)1.0f, (boolean)false);
            this.beamChargeAnim = 20;
            this.setBeamTarget(manager.getArenaOrigin());
            this.setBeamPower(0.0f);
        }
    }

    public void func_174812_G() {
        this.onCrystalAttacked(DamageSource.field_76377_j, 0.0f, true);
        super.func_174812_G();
    }

    private void onCrystalAttacked(DamageSource source, float damage, boolean destroyed) {
        GuardianFightManager manager = this.getManager();
        if (manager != null) {
            manager.onCrystalAttacked(this, source, damage, destroyed);
        }
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.setBeamPower(1.0f);
        this.func_184212_Q().func_187227_b(BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    public void setBeamPower(float beamPower) {
        this.field_70180_af.func_187227_b(BEAM_POWER, (Object)Float.valueOf(beamPower));
    }

    public float getBeamPower() {
        return ((Float)this.field_70180_af.func_187225_a(BEAM_POWER)).floatValue();
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.func_184212_Q().func_187225_a(BEAM_TARGET)).orElse(null);
    }

    public void setShowBottom(boolean showBottom) {
        this.func_184212_Q().func_187227_b(SHOW_BOTTOM, (Object)showBottom);
    }

    public boolean shouldShowBottom() {
        return (Boolean)this.func_184212_Q().func_187225_a(SHOW_BOTTOM);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return super.func_70112_a(distance) || this.getBeamTarget() != null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void destabilize() {
        if (this.getUnstableTime() == 0) {
            BCoreNetwork.sendSound((World)this.field_70170_p, (Entity)this, (SoundEvent)DESounds.crystalDestabilize, (SoundCategory)SoundCategory.HOSTILE, (float)8.0f, (float)(0.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f), (boolean)false);
        }
        this.setUnstableTime(DEConfig.guardianCrystalUnstableWindow);
    }

    public GuardianFightManager getManager() {
        WorldEntity worldEntity;
        if (this.field_70170_p instanceof ServerWorld && this.getManagerId() != null && (worldEntity = WorldEntityHandler.getWorldEntity((World)this.field_70170_p, (UUID)this.managerId)) instanceof GuardianFightManager) {
            return (GuardianFightManager)worldEntity;
        }
        return null;
    }
}

