/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandRespawnGuardian {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"respawn_draconic_guardian").requires(cs -> cs.func_197034_c(2))).executes(context -> CommandRespawnGuardian.respawn((CommandContext<CommandSource>)context, false)));
    }

    private static int respawn(CommandContext<CommandSource> ctx, boolean spawnHere) throws CommandSyntaxException {
        if (spawnHere) {
            return CommandRespawnGuardian.spawnHere(ctx);
        }
        Vector3d pos = ((CommandSource)ctx.getSource()).func_197036_d();
        TileChaosCrystal tile = BlockPos.func_218281_b((BlockPos)new BlockPos(pos).func_177982_a(-60, -60, -60), (BlockPos)new BlockPos(pos).func_177982_a(60, 60, 60)).filter(e -> ((CommandSource)ctx.getSource()).func_197023_e().func_175625_s(e) instanceof TileChaosCrystal).map(e -> (TileChaosCrystal)((CommandSource)ctx.getSource()).func_197023_e().func_175625_s(e)).findAny().orElse(null);
        if (tile == null) {
            throw new CommandException((ITextComponent)new StringTextComponent("Chaos crystal not detected! Please run this command within 60 blocks of an islands chaos crystal."));
        }
        if (tile.parentPos.get().func_177956_o() != -1) {
            TileEntity parent = tile.func_145831_w().func_175625_s(tile.parentPos.get());
            if (parent instanceof TileChaosCrystal) {
                tile = (TileChaosCrystal)parent;
            } else {
                throw new CommandException((ITextComponent)new StringTextComponent("Found invalid chaos crystal at this location"));
            }
        }
        TileChaosCrystal finalTile = tile;
        GuardianFightManager existingFight = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> e.getArenaOrigin().equals((Object)finalTile.func_174877_v())).findAny().orElse(null);
        if (existingFight != null) {
            throw new CommandException((ITextComponent)new StringTextComponent("There should already be a guardian in this area"));
        }
        tile.guardianDefeated.set(false);
        WorldEntityHandler.addWorldEntity((World)tile.func_145831_w(), (WorldEntity)new GuardianFightManager(tile.func_174877_v()));
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Reset Successful. Go to center of island to trigger spawning sequence.").func_240699_a_(TextFormatting.GREEN), true);
        return 0;
    }

    private static int spawnHere(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return 0;
    }
}

