/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class RenderTileReactorCore
extends TileEntityRenderer<TileReactorCore> {
    private static CCModel model = null;
    private static CCModel model_no_shade;
    public static ShaderProgram coreShader;
    public static ShaderProgram shieldShader;
    private static RenderType fallBackType;
    private static RenderType fallBackShieldType;

    public RenderTileReactorCore(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        if (model == null) {
            Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core.obj"), (int)7, null);
            model = CCModel.combine(map.values());
            map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/reactor/reactor_core_model.obj"), (int)7, null);
            model_no_shade = CCModel.combine(map.values()).apply((Transformation)new Scale(-0.5));
        }
    }

    public void render(TileReactorCore te, float partialTicks, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        double diameter = te.getCoreDiameter();
        float t = (float)(te.temperature.get() / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)MathUtils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)MathUtils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)MathUtils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float shieldPower = (float)(te.maxShieldCharge.get() > 0.0 ? te.shieldCharge.get() / te.maxShieldCharge.get() : 0.0);
        float animation = (te.coreAnimation + partialTicks * (float)te.shaderAnimationState.get()) / 20.0f;
        mat.translate(0.5, 0.5, 0.5);
        mat.scale(diameter);
        mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), Vector3.Y_POS);
        RenderTileReactorCore.renderCore(mat, ccrs, animation, te.shaderAnimationState.get(), intensity, shieldPower, partialTicks, getter);
    }

    public static void renderCore(Matrix4 mat, CCRenderState ccrs, float animation, double animState, float intensity, float shieldPower, float partialTicks, IRenderTypeBuffer getter) {
        if (DEConfig.reactorShaders) {
            UniformCache uniforms = coreShader.pushCache();
            uniforms.glUniform1f("time", animation);
            uniforms.glUniform1f("intensity", intensity);
            ccrs.bind((RenderType)new ShaderRenderType(fallBackType, coreShader, uniforms), getter);
            model.render(ccrs, new IVertexOperation[]{mat});
            mat.scale(1.05);
            uniforms = shieldShader.pushCache();
            uniforms.glUniform1f("time", animation);
            uniforms.glUniform1f("intensity", 0.7f * shieldPower - (float)(1.0 - animState));
            ccrs.bind((RenderType)new ShaderRenderType(fallBackShieldType, shieldShader, uniforms), getter);
            model.render(ccrs, new IVertexOperation[]{mat});
        } else {
            ccrs.bind(fallBackType, getter);
            model_no_shade.render(ccrs, new IVertexOperation[]{mat});
            ToolRenderBase.endBatch(getter);
            mat.scale(1.05);
            mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 400.0f), Vector3.X_NEG);
            float r = shieldPower < 0.5f ? 1.0f - shieldPower * 2.0f : 0.0f;
            float g = shieldPower > 0.5f ? (shieldPower - 0.5f) * 2.0f : 0.0f;
            float b = shieldPower * 2.0f;
            float a = shieldPower < 0.1f ? shieldPower * 10.0f : 1.0f;
            ccrs.baseColour = ColourRGBA.packRGBA((double)r, (double)g, (double)b, (double)a);
            ccrs.bind(fallBackShieldType, getter);
            model_no_shade.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    public static void renderGUI(TileReactorCore te, int x, int y) {
        RenderSystem.pushMatrix();
        double diameter = 100.0;
        float t = (float)(te.temperature.get() / 10000.0);
        float intensity = (double)t <= 0.2 ? (float)MathUtils.map((double)t, (double)0.0, (double)0.2, (double)0.0, (double)0.3) : ((double)t <= 0.8 ? (float)MathUtils.map((double)t, (double)0.2, (double)0.8, (double)0.3, (double)1.0) : (float)MathUtils.map((double)t, (double)0.8, (double)1.0, (double)1.0, (double)1.3));
        float animation = (te.coreAnimation + 0.0f * (float)te.shaderAnimationState.get()) / 20.0f;
        float shieldPower = (float)(te.maxShieldCharge.get() > 0.0 ? te.shieldCharge.get() / te.maxShieldCharge.get() : 0.0);
        MatrixStack stack = new MatrixStack();
        Minecraft mc = Minecraft.func_71410_x();
        IRenderTypeBuffer.Impl getter = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Matrix4 mat = new Matrix4(stack);
        mat.scale(diameter);
        mat.rotate((double)(((float)ClientEventHandler.elapsedTicks + mc.func_184121_ak()) / 400.0f), Vector3.Y_POS);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        RenderSystem.translated((double)x, (double)y, (double)100.0);
        RenderSystem.depthMask((boolean)false);
        RenderTileReactorCore.renderCore(mat, ccrs, animation, te.shaderAnimationState.get(), intensity, shieldPower, mc.func_184121_ak(), (IRenderTypeBuffer)getter);
        getter.func_228461_a_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.popMatrix();
    }

    public boolean shouldRenderOffScreen(TileReactorCore te) {
        return true;
    }

    static {
        coreShader = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/reactor.frag")).uniform("time", UniformType.FLOAT).uniform("intensity", UniformType.FLOAT)).build();
        shieldShader = ShaderProgramBuilder.builder().addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/reactor_shield.frag")).uniform("time", UniformType.FLOAT).uniform("intensity", UniformType.FLOAT)).build();
        fallBackType = RenderType.func_228632_a_((String)"fall_back_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_core.png"), false, false)).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
        fallBackShieldType = RenderType.func_228632_a_((String)"fall_back_shield_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_shield.png"), false, false)).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    }
}

