/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.client.model.ModelReactorEnergyInjector;
import com.brandon3055.draconicevolution.client.model.ModelReactorStabilizerCore;
import com.brandon3055.draconicevolution.client.model.ModelReactorStabilizerRing;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;

public class RenderTileReactorComponent
extends TileEntityRenderer<TileReactorComponent> {
    public static final ResourceLocation REACTOR_STABILIZER = new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_stabilizer_core.png");
    public static final ResourceLocation REACTOR_STABILIZER_RING = new ResourceLocation("draconicevolution", "textures/block/reactor/reactor_stabilizer_ring.png");
    public static final ResourceLocation REACTOR_INJECTOR = new ResourceLocation("draconicevolution", "textures/block/reactor/model_reactor_power_injector.png");
    public static ModelReactorStabilizerCore stabilizerModel = new ModelReactorStabilizerCore(RenderType::func_228634_a_);
    public static ModelReactorStabilizerRing stabilizerRingModel = new ModelReactorStabilizerRing(RenderType::func_228634_a_);
    public static ModelReactorEnergyInjector injectorModel = new ModelReactorEnergyInjector(RenderType::func_228634_a_);

    public RenderTileReactorComponent(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileReactorComponent te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        if (te.facing.get() == Direction.SOUTH) {
            matrix.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
        } else if (te.facing.get() == Direction.EAST) {
            matrix.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
        } else if (te.facing.get() == Direction.WEST) {
            matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
        } else if (te.facing.get() == Direction.UP) {
            matrix.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        } else if (te.facing.get() == Direction.DOWN) {
            matrix.func_227863_a_(new Quaternion(-90.0f, 0.0f, 0.0f, true));
        }
        if (te instanceof TileReactorStabilizer) {
            float coreRotation = te.animRotation + partialTicks * te.animRotationSpeed;
            RenderTileReactorComponent.renderStabilizer(matrix, getter, coreRotation, te.animRotationSpeed / 15.0f, packedLight, packedOverlay);
        } else if (te instanceof TileReactorInjector) {
            RenderTileReactorComponent.renderInjector(matrix, getter, te.animRotationSpeed / 15.0f, packedLight, packedOverlay);
        }
    }

    public static void renderStabilizer(MatrixStack matrix, IRenderTypeBuffer getter, float coreRotation, float brightness, int packedLight, int packedOverlay) {
        float ringRotation = coreRotation * -0.5f;
        RenderTileReactorComponent.stabilizerModel.brightness = brightness;
        RenderTileReactorComponent.stabilizerModel.rotation = coreRotation;
        stabilizerModel.func_225598_a_(matrix, getter.getBuffer(stabilizerModel.func_228282_a_(REACTOR_STABILIZER)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrix.func_227863_a_(new Quaternion(90.0f, 0.0f, 0.0f, true));
        matrix.func_227861_a_(0.0, -0.58, 0.0);
        matrix.func_227863_a_(new Quaternion(0.0f, ringRotation, 0.0f, true));
        RenderTileReactorComponent.stabilizerRingModel.brightness = brightness;
        RenderTileReactorComponent.stabilizerRingModel.embitterRotation = 70.0f;
        stabilizerRingModel.func_225598_a_(matrix, getter.getBuffer(stabilizerModel.func_228282_a_(REACTOR_STABILIZER_RING)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static void renderInjector(MatrixStack matrix, IRenderTypeBuffer getter, float brightness, int packedLight, int packedOverlay) {
        RenderTileReactorComponent.injectorModel.brightness = brightness;
        injectorModel.func_225598_a_(matrix, getter.getBuffer(injectorModel.func_228282_a_(REACTOR_INJECTOR)), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

