/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDraconiumChest;
import com.brandon3055.draconicevolution.client.model.ModelDraconiumChest;
import com.brandon3055.draconicevolution.init.DEContent;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderTileDraconiumChest
extends TileEntityRenderer<TileDraconiumChest> {
    public static final ResourceLocation DRACONIUM_CHEST = new ResourceLocation("draconicevolution", "textures/block/draconium_chest.png");
    private final ModelDraconiumChest chestModel = new ModelDraconiumChest(RenderType::func_228634_a_);

    public RenderTileDraconiumChest(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileDraconiumChest tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        float r = (float)(tile.colour.get() >> 16 & 0xFF) / 255.0f;
        float g = (float)(tile.colour.get() >> 8 & 0xFF) / 255.0f;
        float b = (float)(tile.colour.get() & 0xFF) / 255.0f;
        BlockState state = Objects.requireNonNull(tile.func_145831_w()).func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() != DEContent.draconium_chest) {
            return;
        }
        Direction facing = (Direction)state.func_177229_b((Property)DraconiumChest.FACING);
        int facingRotationAngle = 0;
        switch (facing.ordinal()) {
            case 2: {
                facingRotationAngle = 0;
                break;
            }
            case 3: {
                facingRotationAngle = 180;
                break;
            }
            case 4: {
                facingRotationAngle = 90;
                break;
            }
            case 5: {
                facingRotationAngle = -90;
            }
        }
        float lidAngle = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTicks;
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.chestModel.setLidAngle(lidAngle *= 1.5707964f);
        this.chestModel.setFacingDirection(facingRotationAngle);
        this.chestModel.func_225598_a_(matrixStack, getter.getBuffer(this.chestModel.func_228282_a_(DRACONIUM_CHEST)), packedLight, packedOverlay, r, g, b, 1.0f);
    }
}

