/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.IntParticleType;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.BCProfiler;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;

public class ParticleEnergyCoreFX
extends SpriteTexturedParticle {
    public static final IParticleRenderType PARTICLE_NO_DEPTH_NO_LIGHT = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder builder, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            manager.func_110577_a(AtlasTexture.field_215262_g);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.alphaFunc((int)516, (float)0.003921569f);
            builder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        }

        public void func_217599_a(Tessellator tesselator) {
            tesselator.func_78381_a();
        }

        public String toString() {
            return "PARTICLE_NO_DEPTH_NO_LIGHT";
        }
    };
    public Vec3D targetPos;
    public boolean toCore = false;
    public int startRotation = 0;
    private Direction.Axis direction;
    public boolean isLargeStabilizer = false;
    private final IAnimatedSprite spriteSet;

    public ParticleEnergyCoreFX(ClientWorld world, double xPos, double yPos, double zPos, Vec3D targetPos, IAnimatedSprite spriteSet) {
        super(world, xPos, yPos, zPos);
        this.targetPos = targetPos;
        this.spriteSet = spriteSet;
        this.func_217567_a(spriteSet.func_217590_a(world.field_73012_v));
        this.field_190017_n = false;
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(xPos, yPos, zPos), (Vec3D)targetPos);
        this.direction = Direction.func_176737_a((float)((float)dir.x), (float)((float)dir.y), (float)((float)dir.z)).func_176740_k();
        this.field_70547_e = 20;
    }

    public IParticleRenderType func_217558_b() {
        return PARTICLE_NO_DEPTH_NO_LIGHT;
    }

    public void func_189213_a() {
        BCProfiler.TICK.start("core_fx_update");
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        Vec3D tPos = this.targetPos.copy();
        this.func_217567_a(this.spriteSet.func_217590_a(this.field_187122_b.field_73012_v));
        if (this.toCore) {
            double d;
            double rotation = ClientEventHandler.elapsedTicks;
            double offsetX = Math.sin(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double offsetY = Math.cos(rotation / 180.0 * Math.PI + (double)this.startRotation / 100.0);
            double d2 = d = this.isLargeStabilizer ? 1.8 : 0.2;
            if (this.direction == Direction.Axis.Z) {
                tPos.add(offsetX * d, offsetY * d, 0.0);
            } else if (this.direction == Direction.Axis.Y) {
                tPos.add(offsetX * d, 0.0, offsetY * d);
            } else if (this.direction == Direction.Axis.X) {
                tPos.add(0.0, offsetY * d, offsetX * d);
            }
        }
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)tPos);
        double speed = this.toCore ? 0.5 : 0.25;
        this.field_187129_i = dir.x * speed;
        this.field_187130_j = dir.y * speed;
        this.field_187131_k = dir.z * speed;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_70546_d++ > this.field_70547_e || Utils.getDistanceAtoB((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h, (double)tPos.x, (double)tPos.y, (double)tPos.z) < 0.2) {
            this.func_187112_i();
        }
        BCProfiler.TICK.stop();
    }

    public static class Factory
    implements IParticleFactory<IntParticleType.IntParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite p_i50823_1_) {
            this.spriteSet = p_i50823_1_;
        }

        public Particle createParticle(IntParticleType.IntParticleData data, ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleEnergyCoreFX particle = new ParticleEnergyCoreFX(world, x, y, z, new Vec3D(xSpeed, ySpeed, zSpeed), this.spriteSet);
            particle.toCore = data.get().length >= 1 && data.get()[0] == 1;
            particle.startRotation = data.get().length >= 2 ? data.get()[1] : 0;
            particle.isLargeStabilizer = data.get().length >= 3 && data.get()[2] == 1;
            particle.func_70541_f(particle.isLargeStabilizer ? 2.0f : 1.0f);
            return particle;
        }
    }
}

