/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.DETextures;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.TexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuardianChargeParticle
extends TexturedParticle {
    private Vector3 startPos;
    private Vector3 endPos;
    private double angularPos;
    private PhaseManager phaseManager;
    public TextureAtlasSprite sprite = DETextures.ORB_PARTICLE;

    public GuardianChargeParticle(ClientWorld world, Vector3 startPos, Vector3 endPos, double angularPos, int life, PhaseManager phaseManager) {
        super(world, startPos.x, startPos.y, startPos.z);
        this.startPos = startPos;
        this.endPos = endPos;
        this.angularPos = angularPos;
        this.phaseManager = phaseManager;
        this.field_70547_e = life * 4;
        this.func_70538_b(0.75f, 0.0f, 0.0f);
        this.func_70541_f(5.0f);
    }

    public boolean shouldCull() {
        return false;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (!(this.phaseManager.getCurrentPhase() instanceof ChargeUpPhase)) {
            this.field_82339_as = (float)((double)this.field_82339_as - 0.1);
        }
        if (this.field_70546_d++ >= this.field_70547_e || this.field_82339_as <= 0.0f) {
            this.func_187112_i();
        }
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo renderInfo, float partialTicks) {
        Quaternion quaternion;
        if ((float)this.field_70546_d + partialTicks > (float)this.field_70547_e) {
            return;
        }
        Vector3d vector3d = renderInfo.func_216785_c();
        float anim = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e;
        Vector3 pos = MathUtils.interpolateVec3((Vector3)this.startPos, (Vector3)this.endPos, (double)anim);
        float radius = anim * 2.0f + MathHelper.func_76126_a((float)(anim * (float)Math.PI)) * 5.0f;
        float x = (float)(pos.x - vector3d.func_82615_a()) + MathHelper.func_76126_a((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        float y = (float)(pos.y - vector3d.func_82617_b());
        float z = (float)(pos.z - vector3d.func_82616_c()) + MathHelper.func_76134_b((float)((float)(this.angularPos * Math.PI * 2.0) + anim)) * radius;
        if (this.field_190014_F == 0.0f) {
            quaternion = renderInfo.func_227995_f_();
        } else {
            quaternion = new Quaternion(renderInfo.func_227995_f_());
            float f3 = MathHelper.func_219799_g((float)partialTicks, (float)this.field_190015_G, (float)this.field_190014_F);
            quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(x, y, z);
        }
        float uMin = this.func_217563_c();
        float uMax = this.func_217564_d();
        float vMin = this.func_217562_e();
        float vMax = this.func_217560_f();
        int j = 240;
        builder.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(uMax, vMax).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(uMax, vMin).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(uMin, vMin).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(uMin, vMax).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
    }

    public IParticleRenderType func_217558_b() {
        return DETextures.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected float func_217563_c() {
        return this.sprite.func_94209_e();
    }

    protected float func_217564_d() {
        return this.sprite.func_94212_f();
    }

    protected float func_217562_e() {
        return this.sprite.func_94206_g();
    }

    protected float func_217560_f() {
        return this.sprite.func_94210_h();
    }
}

