/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.modelfx;

import codechicken.lib.math.MathHelper;
import codechicken.lib.render.buffer.TransformingVertexBuilder;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.TechLevel;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;

public abstract class ModelEffect {
    public Vector3 pos = new Vector3();
    public double scale = 1.0;
    public float red = 1.0f;
    public float green = 1.0f;
    public float blue = 1.0f;
    public float alpha = 1.0f;
    protected static Random rand;
    private static float[] r;
    private static float[] randSet;
    private static int randPos;

    public abstract RenderType getRenderType();

    protected abstract void doRender(IVertexBuilder var1, float var2, TechLevel var3);

    public void renderEffect(Matrix4 mat, IRenderTypeBuffer getter, float partialTicks, TechLevel techLevel) {
        TransformingVertexBuilder builder = new TransformingVertexBuilder(getter.getBuffer(this.getRenderType()), (Transformation)mat);
        this.doRender((IVertexBuilder)builder, partialTicks, techLevel);
    }

    protected void drawParticle(IVertexBuilder builder, double x, double y, double z, double scale, float red, float green, float blue, float alpha) {
        double min = (1.0 - scale) * 0.5;
        double max = 0.5 + scale * 0.5;
        builder.func_225582_a_(x + min, y + 0.5, z + min).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x + min, y + 0.5, z + max).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + max, y + 0.5, z + max).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + max, y + 0.5, z + min).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x + min, y + min, z + 0.5).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x + min, y + max, z + 0.5).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + max, y + max, z + 0.5).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + max, y + min, z + 0.5).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x + 0.5, y + min, z + min).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        builder.func_225582_a_(x + 0.5, y + min, z + max).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + 0.5, y + max, z + max).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        builder.func_225582_a_(x + 0.5, y + max, z + min).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
    }

    protected void drawPolyParticle(IVertexBuilder builder, double x, double y, double z, double scale, float red, float green, float blue, float alpha) {
        double min = (1.0 - scale) * 0.5;
        double max = 0.5 + scale * 0.5;
        builder.func_225582_a_(x + min, y + 0.5, z + min).func_227885_a_(red, green, blue, alpha).func_227886_a_(240).func_181675_d();
        builder.func_225582_a_(x + min, y + 0.5, z + max).func_227885_a_(red, green, blue, alpha).func_227886_a_(240).func_181675_d();
        builder.func_225582_a_(x + max, y + 0.5, z + max).func_227885_a_(red, green, blue, alpha).func_227886_a_(240).func_181675_d();
        builder.func_225582_a_(x + max, y + 0.5, z + min).func_227885_a_(red, green, blue, alpha).func_227886_a_(240).func_181675_d();
    }

    protected void drawParticle(IVertexBuilder builder, double x, double y, double z) {
        this.drawParticle(builder, x, y, z, this.scale, this.red, this.green, this.blue, this.alpha);
    }

    protected static float noise(float input) {
        int xMin = (int)(input %= (float)r.length - 1.0f);
        float t = input - (float)xMin;
        return MathHelper.interpolate((float)r[xMin], (float)r[xMin + 1], (float)t);
    }

    protected static float flicker(float input) {
        int xMin = (int)(input %= (float)r.length - 1.0f);
        float t = input - (float)xMin;
        return MathHelper.interpolate((float)r[xMin], (float)0.0f, (float)t);
    }

    protected static float flickerFlair(float input) {
        int xMin;
        float t;
        if ((double)(t = (input %= (float)r.length - 1.0f) - (float)(xMin = (int)input)) < 0.1) {
            return MathHelper.interpolate((float)0.0f, (float)r[xMin], (float)(t / 0.1f));
        }
        return MathHelper.interpolate((float)r[xMin], (float)0.0f, (float)((t - 0.1f) / 0.9f));
    }

    protected static float nextFloat() {
        return randSet[randPos++ % randSet.length];
    }

    protected static void setRandSeed(int i) {
        randPos = i % randSet.length;
    }

    static {
        int i;
        rand = new Random();
        r = new float[256];
        randSet = new float[4096];
        randPos = 0;
        rand.setSeed(123L);
        for (i = 0; i < r.length; ++i) {
            ModelEffect.r[i] = rand.nextFloat();
        }
        for (i = 0; i < randSet.length; ++i) {
            ModelEffect.randSet[i] = rand.nextFloat();
        }
    }

    public static class DebugEffect
    extends ModelEffect {
        private RenderType alignRenderType = RenderType.func_228632_a_((String)"alignRenderType", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228515_g_).func_228713_a_(RenderState.field_228516_h_).func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));

        @Override
        public RenderType getRenderType() {
            return this.alignRenderType;
        }

        @Override
        protected void doRender(IVertexBuilder builder, float partialTicks, TechLevel techLevel) {
            this.drawParticle(builder, this.pos.x, this.pos.y, this.pos.z, 0.5, 1.0f, 1.0f, 1.0f, 0.5f);
            this.drawParticle(builder, this.pos.x, this.pos.y + 1.0, this.pos.z, 0.25, 0.0f, 1.0f, 0.0f, 0.5f);
            this.drawParticle(builder, this.pos.x + 1.0, this.pos.y, this.pos.z, 0.25, 1.0f, 0.0f, 0.0f, 0.5f);
            this.drawParticle(builder, this.pos.x, this.pos.y, this.pos.z + 1.0, 0.25, 0.0f, 0.0f, 1.0f, 0.5f);
        }
    }
}

