/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.modelfx;

import codechicken.lib.util.SneakyUtils;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.client.render.modelfx.ModelEffect;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class BowModelEffect
extends ModelEffect {
    private RenderType renderType = RenderType.func_228632_a_((String)"modelEffectType", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/particle/white_orb.png"), false, false)).func_228726_a_(RenderState.field_228512_d_).func_228713_a_(RenderState.field_228516_h_).func_228714_a_(RenderState.field_228491_A_).func_228727_a_(RenderState.field_228496_F_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    private RenderType renderSolidType = RenderType.func_228632_a_((String)"modelEffectType4", (VertexFormat)DefaultVertexFormats.field_227850_m_, (int)6, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228728_a_(false));
    public float animTime = 0.0f;
    public int colour = 0xFFFFFF;

    @Override
    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    protected void doRender(IVertexBuilder builder, float partialTicks, TechLevel techLevel) {
        int pCount = 50;
        float velocity = 0.05f;
        float drag = 0.95f;
        float r = (float)(this.colour >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.colour >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.colour & 0xFF) / 255.0f;
        BowModelEffect.setRandSeed(0);
        for (int i = 0; i < pCount; ++i) {
            float time = this.animTime + (float)(i * 2048);
            float age = time % 20.0f;
            float xVel = (BowModelEffect.nextFloat() - 0.5f) * velocity;
            float yVel = (BowModelEffect.nextFloat() - 0.5f) * velocity;
            float zVel = (BowModelEffect.nextFloat() - 0.5f) * velocity;
            yVel = (float)((double)yVel + 0.002 * (double)age);
            xVel = (float)((double)xVel * Math.pow(drag, age));
            yVel = (float)((double)yVel * Math.pow(drag, age));
            zVel = (float)((double)zVel * Math.pow(drag, age));
            double x = xVel * age;
            double y = yVel * age;
            double z = zVel * age;
            double scaleMod = MathUtils.clampMap((double)age, (double)0.0, (double)5.0, (double)0.0, (double)1.0) * MathUtils.clampMap((double)age, (double)5.0, (double)20.0, (double)1.0, (double)0.0) * (double)Math.min(1.0f, this.animTime / 5.0f);
            this.drawParticle(builder, x, y, z, 0.1 * scaleMod, r, g, b, 1.0f);
        }
    }
}

