/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.OBJParser;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.ShaderProgramBuilder;
import codechicken.lib.render.shader.ShaderRenderType;
import codechicken.lib.render.shader.UniformCache;
import codechicken.lib.render.shader.UniformType;
import codechicken.lib.util.SneakyUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RenderItemEnergyCrystal
implements IItemRenderer {
    public static ShaderProgram crystalShader = ShaderProgramBuilder.builder().addShader("vert", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.VERTEX).source(new ResourceLocation("draconicevolution", "shaders/energy_crystal.vert"))).addShader("frag", shader -> shader.type((ShaderObject.ShaderType)ShaderObject.StandardShaderType.FRAGMENT).source(new ResourceLocation("draconicevolution", "shaders/energy_crystal.frag")).uniform("time", UniformType.FLOAT).uniform("mipmap", UniformType.FLOAT).uniform("type", UniformType.INT).uniform("angle", UniformType.VEC2)).whenUsed(cache -> cache.glUniform1f("time", ((float)ClientEventHandler.elapsedTicks + Minecraft.func_71410_x().func_184121_ak()) / 50.0f)).build();
    public static final RenderType fallBackType = RenderType.func_228632_a_((String)"fall_back_type", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(new ResourceLocation("draconicevolution", "textures/models/crystal_no_shader.png"), false, false)).func_228725_a_(new RenderState.TexturingState("lighting", RenderSystem::disableLighting, SneakyUtils.none())).func_228714_a_(RenderState.field_228491_A_).func_228728_a_(false));
    public static final RenderType crystalBaseType = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    public static final RenderType fallBackOverlayType = RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    private final EnergyCrystal.CrystalType type;
    private final TechLevel techLevel;
    private final CCModel crystalFull;
    private final CCModel crystalHalf;
    private final CCModel crystalBase;
    private static float[] r = new float[]{0.0f, 0.47f, 1.0f};
    private static float[] g = new float[]{0.2f, 0.0f, 0.4f};
    private static float[] b = new float[]{0.3f, 0.58f, 0.1f};

    public RenderItemEnergyCrystal(EnergyCrystal.CrystalType type, TechLevel techLevel) {
        this.type = type;
        this.techLevel = techLevel;
        Map map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/crystal.obj"), (int)7, null);
        this.crystalFull = CCModel.combine(map.values());
        map = OBJParser.parseModels((ResourceLocation)new ResourceLocation("draconicevolution", "models/block/crystal_half.obj"), (int)7, null);
        this.crystalHalf = (CCModel)map.get("Crystal");
        this.crystalBase = (CCModel)map.get("Base");
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public void renderItem(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack mStack, IRenderTypeBuffer getter, int packedLight, int packedOverlay) {
        int tier = this.techLevel.index;
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        mat.translate(0.5, this.type == EnergyCrystal.CrystalType.CRYSTAL_IO ? 0.0 : 0.5, 0.5);
        if (this.type == EnergyCrystal.CrystalType.CRYSTAL_IO) {
            ccrs.bind(crystalBaseType, getter);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            mat.apply((Transformation)new Rotation((double)((float)ClientEventHandler.elapsedTicks / 400.0f), 0.0, 1.0, 0.0));
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            if (DEConfig.crystalShaders) {
                UniformCache uniforms = crystalShader.pushCache();
                uniforms.glUniform1f("mipmap", 0.0f);
                uniforms.glUniform1i("type", tier);
                uniforms.glUniform2f("angle", 0.0f, 0.0f);
                ccrs.bind((RenderType)new ShaderRenderType(fallBackType, crystalShader, uniforms), getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.bind(fallBackType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
                ccrs.bind(fallBackOverlayType, getter);
                this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
            }
        } else {
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            mat.apply((Transformation)new Rotation((double)((float)ClientEventHandler.elapsedTicks / 400.0f), 0.0, 1.0, 0.0));
            if (DEConfig.crystalShaders) {
                UniformCache uniforms = crystalShader.pushCache();
                uniforms.glUniform1f("mipmap", 0.0f);
                uniforms.glUniform1i("type", tier);
                uniforms.glUniform2f("angle", 0.0f, 0.0f);
                ccrs.bind((RenderType)new ShaderRenderType(fallBackType, crystalShader, uniforms), getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            } else {
                ccrs.bind(fallBackType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
                ccrs.baseColour = -1;
                ccrs.bind(fallBackOverlayType, getter);
                this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
            }
        }
    }

    public IModelTransform getModelTransform() {
        return TransformUtils.DEFAULT_BLOCK;
    }
}

